/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.init;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;
import xox.labvorty.weaversparadise.items.BottledDyeItem;
import xox.labvorty.weaversparadise.items.ChromaticBloomFruit;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class WeaversParadiseColorHandlers {
    private static final List<String> dyeTypes = List.of("agender", "aroace", "aromantic", "asexual", "bisexual", "demiboy", "demigender", "demigirl", "gay", "genderfluid", "genderqueer", "intersex", "lesbian", "nonbinary", "pansexual", "pride", "trans");
    private static final List<Integer> prideColors = List.of(Integer.valueOf(14942979), Integer.valueOf(16747520), Integer.valueOf(16772352), Integer.valueOf(32806), Integer.valueOf(19967), Integer.valueOf(7669639));
    private static final List<Integer> asexualColors = List.of(Integer.valueOf(0x2E2E2E), Integer.valueOf(0xA3A3A3), Integer.valueOf(0xFFFFFF), Integer.valueOf(0x800080));
    private static final List<Integer> aromanticColors = List.of(Integer.valueOf(4040002), Integer.valueOf(10998649), Integer.valueOf(0xFFFFFF), Integer.valueOf(0xA9A9A9), Integer.valueOf(0x2E2E2E));
    private static final List<Integer> aroaceColors = List.of(Integer.valueOf(14846976), Integer.valueOf(16766720), Integer.valueOf(0xFFFFFF), Integer.valueOf(42208), Integer.valueOf(0x800080));
    private static final List<Integer> agenderColors = List.of(Integer.valueOf(0x2E2E2E), Integer.valueOf(0xB9B9B9), Integer.valueOf(0xFFFFFF), Integer.valueOf(12121219), Integer.valueOf(0xFFFFFF), Integer.valueOf(0xB9B9B9), Integer.valueOf(0x2E2E2E));
    private static final List<Integer> bisexualColors = List.of(Integer.valueOf(14025328), Integer.valueOf(14025328), Integer.valueOf(10178454), Integer.valueOf(14504), Integer.valueOf(14504));
    private static final List<Integer> demiboyColors = List.of(Integer.valueOf(0x2E2E2E), Integer.valueOf(0x7F7F7F), Integer.valueOf(10148331), Integer.valueOf(0xFFFFFF), Integer.valueOf(10148331), Integer.valueOf(0x7F7F7F), Integer.valueOf(0x2E2E2E));
    private static final List<Integer> demigenderColors = List.of(Integer.valueOf(0x2E2E2E), Integer.valueOf(0x7F7F7F), Integer.valueOf(16380011), Integer.valueOf(0xFFFFFF), Integer.valueOf(16380011), Integer.valueOf(0x7F7F7F), Integer.valueOf(0x2E2E2E));
    private static final List<Integer> demigirlColors = List.of(Integer.valueOf(0x2E2E2E), Integer.valueOf(0x7F7F7F), Integer.valueOf(16559305), Integer.valueOf(0xFFFFFF), Integer.valueOf(16559305), Integer.valueOf(0x7F7F7F), Integer.valueOf(0x2E2E2E));
    private static final List<Integer> gayColors = List.of(Integer.valueOf(494960), Integer.valueOf(2543274), Integer.valueOf(10021057), Integer.valueOf(0xFFFFFF), Integer.valueOf(8105443), Integer.valueOf(5261772), Integer.valueOf(4004472));
    private static final List<Integer> genderfluidColors = List.of(Integer.valueOf(16741794), Integer.valueOf(0xFFFFFF), Integer.valueOf(12458198), Integer.valueOf(0x2E2E2E), Integer.valueOf(3358397));
    private static final List<Integer> genderqueerColors = List.of(Integer.valueOf(11894492), Integer.valueOf(0xFFFFFF), Integer.valueOf(4817451));
    private static final List<Integer> intersexColors = List.of(Integer.valueOf(16766976), Integer.valueOf(16766976), Integer.valueOf(7930538), Integer.valueOf(16766976), Integer.valueOf(7930538), Integer.valueOf(16766976), Integer.valueOf(16766976));
    private static final List<Integer> lesbianColors = List.of(Integer.valueOf(14035200), Integer.valueOf(16751445), Integer.valueOf(0xFFFFFF), Integer.valueOf(13918630), Integer.valueOf(10813538));
    private static final List<Integer> nonbinaryColors = List.of(Integer.valueOf(16774192), Integer.valueOf(0xFFFFFF), Integer.valueOf(10246609), Integer.valueOf(0x2E2E2E));
    private static final List<Integer> pansexualColors = List.of(Integer.valueOf(16720268), Integer.valueOf(16766976), Integer.valueOf(2208255));
    private static final List<Integer> transColors = List.of(Integer.valueOf(6016762), Integer.valueOf(16099768), Integer.valueOf(0xFFFFFF), Integer.valueOf(16099768), Integer.valueOf(6016762));

    @SubscribeEvent
    public static void itemHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, layer) -> {
            if (layer == 0) {
                return -1;
            }
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof BottledDyeItem) {
                BottledDyeItem dye = (BottledDyeItem)patt0$temp;
                CompoundTag compoundTag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                if (compoundTag.getString("dyeType").equals("redstone")) {
                    int lightValue = compoundTag.getInt("lightValue");
                    int minRed = 100;
                    int maxRed = 255;
                    int color = Mth.lerpInt((float)((float)lightValue / 15.0f), (int)minRed, (int)maxRed);
                    return 0xFF000000 | color << 16 | 0 | 0;
                }
                if (compoundTag.getString("dyeType").equals("rainbow")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    float speed = 0.05f;
                    float red = Mth.clamp((float)((float)(Math.sin((float)ticks * speed) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
                    float green = Mth.clamp((float)((float)(Math.sin((double)((float)ticks * speed) + 2.0943951023931953) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
                    float blue = Mth.clamp((float)((float)(Math.sin((double)((float)ticks * speed) + 4.1887902047863905) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
                    int truered = (int)(red * 255.0f);
                    int truegreen = (int)(green * 255.0f);
                    int trueblue = (int)(blue * 255.0f);
                    return 0xFF000000 | truered << 16 | truegreen << 8 | trueblue;
                }
                if (compoundTag.getString("dyeType").equals("ender")) {
                    return -16777216;
                }
                if (compoundTag.getString("dyeType").equals("speed")) {
                    Minecraft mc = Minecraft.getInstance();
                    Vec3 vec3 = mc.player.getDeltaMovement();
                    double velocity = vec3.lengthSqr();
                    int colorOne = dye.getItemMainColor(stack);
                    int colorTwo = dye.getItemSecondaryColor(stack);
                    int redOne = colorOne >> 16 & 0xFF;
                    int greenOne = colorOne >> 8 & 0xFF;
                    int blueOne = colorOne & 0xFF;
                    int redTwo = colorTwo >> 16 & 0xFF;
                    int greenTwo = colorTwo >> 8 & 0xFF;
                    int blueTwo = colorTwo & 0xFF;
                    int finalRed = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)redOne, (int)redTwo);
                    int finalGreen = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)greenOne, (int)greenTwo);
                    int finalBlue = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)blueOne, (int)blueTwo);
                    int finalColor = 0xFF000000 | finalRed << 16 | finalGreen << 8 | finalBlue;
                    return finalColor;
                }
                if (compoundTag.getString("dyeType").equals("height_bedrock")) {
                    Minecraft mc = Minecraft.getInstance();
                    int absoluteMinimum = mc.level.getMinBuildHeight();
                    int absoluteMaximum = mc.level.getMaxBuildHeight();
                    int height = (int)mc.player.getY();
                    float value = Mth.clamp((float)(((float)height - (float)absoluteMinimum) / ((float)absoluteMaximum - (float)absoluteMinimum)), (float)0.0f, (float)1.0f);
                    int colorOne = dye.getItemMainColor(stack);
                    int colorTwo = dye.getItemSecondaryColor(stack);
                    int redOne = colorOne >> 16 & 0xFF;
                    int greenOne = colorOne >> 8 & 0xFF;
                    int blueOne = colorOne & 0xFF;
                    int redTwo = colorTwo >> 16 & 0xFF;
                    int greenTwo = colorTwo >> 8 & 0xFF;
                    int blueTwo = colorTwo & 0xFF;
                    int finalRed = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
                    int finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
                    int finalBlue = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
                    int finalColor = 0xFF000000 | finalRed << 16 | finalGreen << 8 | finalBlue;
                    return finalColor;
                }
                if (compoundTag.getString("dyeType").equals("height_sea")) {
                    Minecraft mc = Minecraft.getInstance();
                    double minY = mc.level.getMinBuildHeight();
                    double maxY = mc.level.getMaxBuildHeight();
                    double seaY = mc.level.getSeaLevel();
                    double playerY = mc.player.getY();
                    double distanceAbove = maxY - seaY;
                    double distanceBelow = seaY - minY;
                    double maxDistance = Math.max(distanceAbove, distanceBelow);
                    float value = (float)Mth.clamp((double)(Math.abs(playerY - seaY) / maxDistance), (double)0.0, (double)1.0);
                    int colorOne = dye.getItemMainColor(stack);
                    int colorTwo = dye.getItemSecondaryColor(stack);
                    int redOne = colorOne >> 16 & 0xFF;
                    int greenOne = colorOne >> 8 & 0xFF;
                    int blueOne = colorOne & 0xFF;
                    int redTwo = colorTwo >> 16 & 0xFF;
                    int greenTwo = colorTwo >> 8 & 0xFF;
                    int blueTwo = colorTwo & 0xFF;
                    int finalRed = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
                    int finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
                    int finalBlue = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
                    int finalColor = 0xFF000000 | finalRed << 16 | finalGreen << 8 | finalBlue;
                    return finalColor;
                }
                if (compoundTag.getString("dyeType").equals("sculk")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    int pulseInterval = 70;
                    int pulseDuration = 20;
                    int timeInCycle = ticks % pulseInterval;
                    int pulseStartTick = 0;
                    int baseColor = -16439763;
                    int pulseColorValue = -16711681;
                    if (timeInCycle >= pulseStartTick && timeInCycle <= pulseStartTick + pulseDuration) {
                        float fade = 1.0f - (float)(timeInCycle - pulseStartTick) / (float)pulseDuration;
                        return WeaversParadiseColorHandlers.blendColors(pulseColorValue, baseColor, fade);
                    }
                    return baseColor;
                }
                if (compoundTag.getString("dyeType").equals("lamp")) {
                    int colorOne = dye.getItemMainColor(stack);
                    int lightValue = dye.getItemLightValue(stack);
                    int redOne = colorOne >> 16 & 0xFF;
                    int greenOne = colorOne >> 8 & 0xFF;
                    int blueOne = colorOne & 0xFF;
                    int lowestRed = (int)((double)redOne * 0.4);
                    int lowestGreen = (int)((double)greenOne * 0.4);
                    int lowestBlue = (int)((double)blueOne * 0.4);
                    int finalRed = Mth.lerpInt((float)((float)lightValue / 15.0f), (int)lowestRed, (int)redOne);
                    int finalGreen = Mth.lerpInt((float)((float)lightValue / 15.0f), (int)lowestGreen, (int)greenOne);
                    int finalBlue = Mth.lerpInt((float)((float)lightValue / 15.0f), (int)lowestBlue, (int)blueOne);
                    int finalColor = 0xFF000000 | finalRed << 16 | finalGreen << 8 | finalBlue;
                    return finalColor;
                }
                if (compoundTag.getString("dyeType").equals("pride")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(prideColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("asexual")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(asexualColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("aromantic")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(aromanticColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("aroace")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(aroaceColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("agender")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(agenderColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("bisexual")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(bisexualColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("demiboy")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(demiboyColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("demigender")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(demigenderColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("demigirl")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(demigirlColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("gay")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(gayColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("genderfluid")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(genderfluidColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("genderqueer")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(genderqueerColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("intersex")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(intersexColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("lesbian")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(lesbianColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("nonbinary")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(nonbinaryColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("pansexual")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(pansexualColors, ticks);
                }
                if (compoundTag.getString("dyeType").equals("trans")) {
                    Minecraft mc = Minecraft.getInstance();
                    int ticks = (int)mc.level.getGameTime();
                    return WeaversParadiseColorHandlers.getCycledColor(transColors, ticks);
                }
                return dye.getItemMainColor(stack);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)WeaversParadiseItems.BOTTLED_DYE.get()});
        event.register((stack, layer) -> {
            if (layer == 0) {
                return -1;
            }
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof ChromaticBloomFruit) {
                ChromaticBloomFruit bloomFruit = (ChromaticBloomFruit)patt0$temp;
                Minecraft mc = Minecraft.getInstance();
                int ticks = (int)mc.level.getGameTime() + layer * 2;
                float speed = 0.05f;
                float red = Mth.clamp((float)((float)(Math.sin((float)ticks * speed) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
                float green = Mth.clamp((float)((float)(Math.sin((double)((float)ticks * speed) + 2.0943951023931953) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
                float blue = Mth.clamp((float)((float)(Math.sin((double)((float)ticks * speed) + 4.1887902047863905) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
                int truered = (int)(red * 255.0f);
                int truegreen = (int)(green * 255.0f);
                int trueblue = (int)(blue * 255.0f);
                return 0xFF000000 | truered << 16 | truegreen << 8 | trueblue;
            }
            return -1;
        }, new ItemLike[]{WeaversParadiseItems.CHROMATIC_BLOOM_FRUIT});
    }

    public static int blendColors(int c1, int c2, float ratio) {
        ratio = Math.min(1.0f, Math.max(0.0f, ratio));
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 * ratio + (float)r2 * (1.0f - ratio));
        int g = (int)((float)g1 * ratio + (float)g2 * (1.0f - ratio));
        int b = (int)((float)b1 * ratio + (float)b2 * (1.0f - ratio));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int getCycledColor(List<Integer> colors, int ticks) {
        if (colors == null || colors.isEmpty()) {
            return 0xFFFFFF;
        }
        if (colors.size() == 1) {
            return colors.get(0);
        }
        int holdTime = 20;
        int fadeTime = 20;
        int segmentTime = holdTime + fadeTime;
        int totalCycle = colors.size() * segmentTime;
        int time = ticks % totalCycle;
        int index = time / segmentTime;
        int local = time % segmentTime;
        int current = colors.get(index);
        int next = colors.get((index + 1) % colors.size());
        float t = 0.0f;
        if (local >= holdTime) {
            t = (float)(local - holdTime) / (float)fadeTime;
        }
        return WeaversParadiseColorHandlers.lerpColor(current, next, t);
    }

    private static int lerpColor(int c1, int c2, float t) {
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

