/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.tooltips;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import xox.labvorty.weaversparadise.data.WeaversParadiseDyeTextHandler;

@OnlyIn(value=Dist.CLIENT)
public class ImageClientTooltipComponent
implements ClientTooltipComponent {
    private final List<ResourceLocation> textures;
    private int width;
    private int height;
    private final ResourceLocation textureOne;
    private final String textOne;
    private final String typeOne;
    private final int lightValueOne;
    private final int primaryLeftColorOne;
    private final int secondaryLeftColorOne;
    private final ResourceLocation textureTwo;
    private final String textTwo;
    private final String typeTwo;
    private final int lightValueTwo;
    private final int primaryLeftColorTwo;
    private final int secondaryLeftColorTwo;
    private final ResourceLocation textureThree;
    private final String textThree;
    private final String typeThree;
    private final int lightValueThree;
    private final int primaryRightColorOne;
    private final int secondaryRightColorOne;
    private final ResourceLocation textureFour;
    private final String textFour;
    private final String typeFour;
    private final int lightValueFour;
    private final int primaryRightColorTwo;
    private final int secondaryRightColorTwo;
    private static final int[] FIXED_SEQUENCE = new int[]{2, 3, 1, 4, 2, 4, 1, 3, 2, 4, 3, 1, 2, 3, 4, 1, 2, 4, 3, 1, 4, 2, 3, 1, 4, 3, 2, 1, 3, 4, 2, 1, 3, 2, 4, 1, 3, 4, 2, 1, 4, 3, 2, 4, 1, 3, 2, 1, 4, 3, 1, 2, 4, 3, 1, 2, 3, 4, 1, 2, 4, 3, 1, 2, 3, 4, 2, 1, 3, 4, 2, 1, 4, 3, 2, 1, 3, 4, 2, 1, 3, 2, 4, 1, 3, 2, 4, 3, 1, 2, 4, 3, 1, 2, 3, 4, 1, 2, 3, 1};

    public ImageClientTooltipComponent(List<ResourceLocation> textures, ResourceLocation textureOne, String textOne, String typeOne, int lightValueOne, int primaryLeftColorOne, int secondaryLeftColorOne, ResourceLocation textureTwo, String textTwo, String typeTwo, int lightValueTwo, int primaryLeftColorTwo, int secondaryLeftColorTwo, ResourceLocation textureThree, String textThree, String typeThree, int lightValueThree, int primaryRightColorOne, int secondaryRightColorOne, ResourceLocation textureFour, String textFour, String typeFour, int lightValueFour, int primaryRightColorTwo, int secondaryRightColorTwo) {
        this(textures, 8, typeOne.equals("none") ? 8 : (typeTwo.equals("none") ? 18 : (typeThree.equals("none") ? 28 : (typeFour.equals("none") ? 38 : 48))), textureOne, textOne, typeOne, lightValueOne, primaryLeftColorOne, secondaryLeftColorOne, textureTwo, textTwo, typeTwo, lightValueTwo, primaryLeftColorTwo, secondaryLeftColorTwo, textureThree, textThree, typeThree, lightValueThree, primaryRightColorOne, secondaryRightColorOne, textureFour, textFour, typeFour, lightValueFour, primaryRightColorTwo, secondaryRightColorTwo);
    }

    public ImageClientTooltipComponent(List<ResourceLocation> textures, int width, int height, ResourceLocation textureOne, String textOne, String typeOne, int lightValueOne, int primaryLeftColorOne, int secondaryLeftColorOne, ResourceLocation textureTwo, String textTwo, String typeTwo, int lightValueTwo, int primaryLeftColorTwo, int secondaryLeftColorTwo, ResourceLocation textureThree, String textThree, String typeThree, int lightValueThree, int primaryRightColorOne, int secondaryRightColorOne, ResourceLocation textureFour, String textFour, String typeFour, int lightValueFour, int primaryRightColorTwo, int secondaryRightColorTwo) {
        this.textures = textures;
        this.width = width;
        this.height = height;
        this.textureOne = textureOne;
        this.textOne = textOne;
        this.typeOne = typeOne;
        this.lightValueOne = lightValueOne;
        this.primaryLeftColorOne = primaryLeftColorOne;
        this.secondaryLeftColorOne = secondaryLeftColorOne;
        this.textureTwo = textureTwo;
        this.textTwo = textTwo;
        this.typeTwo = typeTwo;
        this.lightValueTwo = lightValueTwo;
        this.primaryLeftColorTwo = primaryLeftColorTwo;
        this.secondaryLeftColorTwo = secondaryLeftColorTwo;
        this.textureThree = textureThree;
        this.textThree = textThree;
        this.typeThree = typeThree;
        this.lightValueThree = lightValueThree;
        this.primaryRightColorOne = primaryRightColorOne;
        this.secondaryRightColorOne = secondaryRightColorOne;
        this.textureFour = textureFour;
        this.textFour = textFour;
        this.typeFour = typeFour;
        this.lightValueFour = lightValueFour;
        this.primaryRightColorTwo = primaryRightColorTwo;
        this.secondaryRightColorTwo = secondaryRightColorTwo;
    }

    public int getHeight() {
        return this.height + 2;
    }

    public int getWidth(Font font) {
        return Math.max(Math.max(this.width + 2 + font.width(WeaversParadiseDyeTextHandler.getOrDefault(this.textOne).getText()), this.width + 2 + font.width(WeaversParadiseDyeTextHandler.getOrDefault(this.textTwo).getText())), Math.max(this.width + 2 + font.width(WeaversParadiseDyeTextHandler.getOrDefault(this.textThree).getText()), this.width + 2 + font.width(WeaversParadiseDyeTextHandler.getOrDefault(this.textFour).getText())));
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        Minecraft mc = Minecraft.getInstance();
        int ticks = (int)mc.level.getGameTime();
        for (int i = 0; i < this.textures.size(); ++i) {
            guiGraphics.blit(this.textures.get(i), x + i * 9, y, 0.0f, 0.0f, 8, 8, 8, 8);
        }
        guiGraphics.blit(this.textureOne, x, y + 9, 0.0f, 0.0f, 8, 8, 8, 8);
        guiGraphics.drawString(font, (Component)this.getComponentFromType(this.textOne, this.typeOne, ticks, this.primaryLeftColorOne, this.secondaryLeftColorOne, this.lightValueOne), x + 10, y + 10, 0xFFFFFF);
        guiGraphics.blit(this.textureTwo, x, y + 18, 0.0f, 0.0f, 8, 8, 8, 8);
        guiGraphics.drawString(font, (Component)this.getComponentFromType(this.textTwo, this.typeTwo, ticks, this.primaryLeftColorTwo, this.secondaryLeftColorTwo, this.lightValueTwo), x + 10, y + 19, 0xFFFFFF);
        guiGraphics.blit(this.textureThree, x, y + 27, 0.0f, 0.0f, 8, 8, 8, 8);
        guiGraphics.drawString(font, (Component)this.getComponentFromType(this.textThree, this.typeThree, ticks, this.primaryRightColorOne, this.secondaryRightColorOne, this.lightValueThree), x + 10, y + 28, 0xFFFFFF);
        guiGraphics.blit(this.textureFour, x, y + 36, 0.0f, 0.0f, 8, 8, 8, 8);
        guiGraphics.drawString(font, (Component)this.getComponentFromType(this.textFour, this.typeFour, ticks, this.primaryRightColorTwo, this.secondaryRightColorTwo, this.lightValueFour), x + 10, y + 37, 0xFFFFFF);
        RenderSystem.disableBlend();
    }

    public MutableComponent getComponentFromType(String stext, String type, int ticks, int primaryColor, int secondaryColor, int lightValue) {
        MutableComponent component = Component.empty();
        int primRed = primaryColor >> 16 & 0xFF;
        int primGreen = primaryColor >> 8 & 0xFF;
        int primBlue = primaryColor & 0xFF;
        int secRed = secondaryColor >> 16 & 0xFF;
        int secGreen = secondaryColor >> 8 & 0xFF;
        int secBlue = secondaryColor & 0xFF;
        String text = WeaversParadiseDyeTextHandler.getOrDefault(stext).getText();
        List<Integer> prideColors = List.of(Integer.valueOf(14942979), Integer.valueOf(16747520), Integer.valueOf(16772352), Integer.valueOf(32806), Integer.valueOf(19967), Integer.valueOf(7669639));
        List<Integer> asexualColors = List.of(Integer.valueOf(0x2E2E2E), Integer.valueOf(0xA3A3A3), Integer.valueOf(0xFFFFFF), Integer.valueOf(0x800080));
        List<Integer> aromanticColors = List.of(Integer.valueOf(4040002), Integer.valueOf(10998649), Integer.valueOf(0xFFFFFF), Integer.valueOf(0xA9A9A9), Integer.valueOf(0x2E2E2E));
        List<Integer> aroaceColors = List.of(Integer.valueOf(14846976), Integer.valueOf(16766720), Integer.valueOf(0xFFFFFF), Integer.valueOf(42208), Integer.valueOf(0x800080));
        List<Integer> agenderColors = List.of(Integer.valueOf(0x2E2E2E), Integer.valueOf(0xB9B9B9), Integer.valueOf(0xFFFFFF), Integer.valueOf(12121219), Integer.valueOf(0xFFFFFF), Integer.valueOf(0xB9B9B9), Integer.valueOf(0x2E2E2E));
        List<Integer> bisexualColors = List.of(Integer.valueOf(14025328), Integer.valueOf(14025328), Integer.valueOf(10178454), Integer.valueOf(14504), Integer.valueOf(14504));
        List<Integer> demiboyColors = List.of(Integer.valueOf(0x2E2E2E), Integer.valueOf(0x7F7F7F), Integer.valueOf(10148331), Integer.valueOf(0xFFFFFF), Integer.valueOf(10148331), Integer.valueOf(0x7F7F7F), Integer.valueOf(0x2E2E2E));
        List<Integer> demigenderColors = List.of(Integer.valueOf(0x2E2E2E), Integer.valueOf(0x7F7F7F), Integer.valueOf(16380011), Integer.valueOf(0xFFFFFF), Integer.valueOf(16380011), Integer.valueOf(0x7F7F7F), Integer.valueOf(0x2E2E2E));
        List<Integer> demigirlColors = List.of(Integer.valueOf(0x2E2E2E), Integer.valueOf(0x7F7F7F), Integer.valueOf(16559305), Integer.valueOf(0xFFFFFF), Integer.valueOf(16559305), Integer.valueOf(0x7F7F7F), Integer.valueOf(0x2E2E2E));
        List<Integer> gayColors = List.of(Integer.valueOf(494960), Integer.valueOf(2543274), Integer.valueOf(10021057), Integer.valueOf(0xFFFFFF), Integer.valueOf(8105443), Integer.valueOf(5261772), Integer.valueOf(4004472));
        List<Integer> genderfluidColors = List.of(Integer.valueOf(16741794), Integer.valueOf(0xFFFFFF), Integer.valueOf(12458198), Integer.valueOf(0x2E2E2E), Integer.valueOf(3358397));
        List<Integer> genderqueerColors = List.of(Integer.valueOf(11894492), Integer.valueOf(0xFFFFFF), Integer.valueOf(4817451));
        List<Integer> intersexColors = List.of(Integer.valueOf(16766976), Integer.valueOf(16766976), Integer.valueOf(7930538), Integer.valueOf(16766976), Integer.valueOf(7930538), Integer.valueOf(16766976), Integer.valueOf(16766976));
        List<Integer> lesbianColors = List.of(Integer.valueOf(14035200), Integer.valueOf(16751445), Integer.valueOf(0xFFFFFF), Integer.valueOf(13918630), Integer.valueOf(10813538));
        List<Integer> nonbinaryColors = List.of(Integer.valueOf(16774192), Integer.valueOf(0xFFFFFF), Integer.valueOf(10246609), Integer.valueOf(0x2E2E2E));
        List<Integer> pansexualColors = List.of(Integer.valueOf(16720268), Integer.valueOf(16766976), Integer.valueOf(2208255));
        List<Integer> transColors = List.of(Integer.valueOf(6016762), Integer.valueOf(16099768), Integer.valueOf(0xFFFFFF), Integer.valueOf(16099768), Integer.valueOf(6016762));
        if (type.equals("default")) {
            component = Component.literal((String)text).withStyle(style -> style.withColor(primaryColor));
        } else if (type.equals("ender")) {
            component = Component.literal((String)text).withStyle(style -> style.withColor(0x2E2E2E));
        } else if (type.equals("rainbow")) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                int color = this.getRainbowColorFromTick(ticks + 3 * i);
                MutableComponent letter = Component.literal((String)String.valueOf(c)).withStyle(style -> style.withColor(color));
                component.append((Component)letter);
            }
        } else if (type.equals("sculk")) {
            int length = text.length();
            int middle = length / 2;
            int pulseInterval = 70;
            int pulseDuration = 20;
            int timeInCycle = ticks % pulseInterval;
            for (int i = 0; i < length; ++i) {
                int finalColor;
                char c = text.charAt(i);
                int distFromMiddle = Math.abs(i - middle);
                int pulseStartTick = distFromMiddle * (pulseDuration / middle);
                int baseColor = 337453;
                int pulseColor = 65535;
                if (timeInCycle >= pulseStartTick && timeInCycle <= pulseStartTick + pulseDuration) {
                    float fade = 1.0f - (float)(timeInCycle - pulseStartTick) / (float)pulseDuration;
                    finalColor = this.blendColors(pulseColor, baseColor, fade);
                } else {
                    finalColor = baseColor;
                }
                MutableComponent letter = Component.literal((String)String.valueOf(c)).withStyle(style -> style.withColor(finalColor));
                component.append((Component)letter);
            }
        } else if (type.equals("biome")) {
            Minecraft mine = Minecraft.getInstance();
            BlockPos bpos = new BlockPos((int)mine.player.getX(), (int)mine.player.getY(), (int)mine.player.getZ());
            int color = ((Biome)mine.level.getBiome(bpos).value()).getGrassColor(mine.player.getX(), mine.player.getZ());
            component = Component.literal((String)text).withStyle(style -> style.withColor(color));
        } else if (type.equals("glowstone")) {
            int baseRed = 181;
            int baseGreen = 113;
            int baseBlue = 66;
            int glowRed = 248;
            int glowGreen = 212;
            int glowBlue = 156;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                float t = (float)(Math.sin((double)(ticks + FIXED_SEQUENCE[i]) * 0.5) + 1.0) / 2.0f;
                int colorRed = Mth.lerpInt((float)t, (int)baseRed, (int)glowRed);
                int colorGreen = Mth.lerpInt((float)t, (int)baseGreen, (int)glowGreen);
                int colorBlue = Mth.lerpInt((float)t, (int)baseBlue, (int)glowBlue);
                int color = 0xFF000000 | colorRed << 16 | colorGreen << 8 | colorBlue;
                component.append((Component)Component.literal((String)String.valueOf(c)).withStyle(style -> style.withColor(color)));
            }
        } else if (type.equals("redstone")) {
            int minRed = 100;
            int maxRed = 255;
            int color = Mth.lerpInt((float)((float)lightValue / 15.0f), (int)minRed, (int)maxRed);
            component = Component.literal((String)text).withStyle(style -> style.withColor(0xFF000000 | color << 16 | 0 | 0));
        } else if (type.equals("lamp")) {
            int lowestRed = (int)((double)primRed * 0.4);
            int lowestGreen = (int)((double)primGreen * 0.4);
            int lowestBlue = (int)((double)primBlue * 0.4);
            int finalRed = Mth.lerpInt((float)((float)lightValue / 15.0f), (int)lowestRed, (int)primRed);
            int finalGreen = Mth.lerpInt((float)((float)lightValue / 15.0f), (int)lowestGreen, (int)primGreen);
            int finalBlue = Mth.lerpInt((float)((float)lightValue / 15.0f), (int)lowestBlue, (int)primBlue);
            int finalColor = 0xFF000000 | finalRed << 16 | finalGreen << 8 | finalBlue;
            component = Component.literal((String)text).withStyle(style -> style.withColor(finalColor));
        } else if (type.equals("speed")) {
            Minecraft mc = Minecraft.getInstance();
            Vec3 vec3 = mc.player.getDeltaMovement();
            double velocity = vec3.lengthSqr();
            int colorOne = primaryColor;
            int colorTwo = secondaryColor;
            int redOne = colorOne >> 16 & 0xFF;
            int greenOne = colorOne >> 8 & 0xFF;
            int blueOne = colorOne & 0xFF;
            int redTwo = colorTwo >> 16 & 0xFF;
            int greenTwo = colorTwo >> 8 & 0xFF;
            int blueTwo = colorTwo & 0xFF;
            int finalRed = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)redOne, (int)redTwo);
            int finalGreen = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)greenOne, (int)greenTwo);
            int finalBlue = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)blueOne, (int)blueTwo);
            int finalColor = 0xFF000000 | finalRed << 16 | finalGreen << 8 | finalBlue;
            component = Component.literal((String)text).withStyle(style -> style.withColor(finalColor));
        } else if (type.equals("height_bedrock")) {
            Minecraft mc = Minecraft.getInstance();
            int absoluteMinimum = mc.level.getMinBuildHeight();
            int absoluteMaximum = mc.level.getMaxBuildHeight();
            int height = (int)mc.player.getY();
            float value = Mth.clamp((float)(((float)height - (float)absoluteMinimum) / ((float)absoluteMaximum - (float)absoluteMinimum)), (float)0.0f, (float)1.0f);
            int colorOne = primaryColor;
            int colorTwo = secondaryColor;
            int redOne = colorOne >> 16 & 0xFF;
            int greenOne = colorOne >> 8 & 0xFF;
            int blueOne = colorOne & 0xFF;
            int redTwo = colorTwo >> 16 & 0xFF;
            int greenTwo = colorTwo >> 8 & 0xFF;
            int blueTwo = colorTwo & 0xFF;
            int finalRed = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
            int finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
            int finalBlue = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
            int finalColor = 0xFF000000 | finalRed << 16 | finalGreen << 8 | finalBlue;
            component = Component.literal((String)text).withStyle(style -> style.withColor(finalColor));
        } else if (type.equals("height_sea")) {
            Minecraft mc = Minecraft.getInstance();
            double minY = mc.level.getMinBuildHeight();
            double maxY = mc.level.getMaxBuildHeight();
            double seaY = mc.level.getSeaLevel();
            double playerY = mc.player.getY();
            double distanceAbove = maxY - seaY;
            double distanceBelow = seaY - minY;
            double maxDistance = Math.max(distanceAbove, distanceBelow);
            float value = (float)Mth.clamp((double)(Math.abs(playerY - seaY) / maxDistance), (double)0.0, (double)1.0);
            int colorOne = primaryColor;
            int colorTwo = secondaryColor;
            int redOne = colorOne >> 16 & 0xFF;
            int greenOne = colorOne >> 8 & 0xFF;
            int blueOne = colorOne & 0xFF;
            int redTwo = colorTwo >> 16 & 0xFF;
            int greenTwo = colorTwo >> 8 & 0xFF;
            int blueTwo = colorTwo & 0xFF;
            int finalRed = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
            int finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
            int finalBlue = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
            int finalColor = 0xFF000000 | finalRed << 16 | finalGreen << 8 | finalBlue;
            component = Component.literal((String)text).withStyle(style -> style.withColor(finalColor));
        } else if (!type.equals("none")) {
            if (type.equals("pride")) {
                component = ImageClientTooltipComponent.flagText(text, prideColors, ticks);
            } else if (type.equals("asexual")) {
                component = ImageClientTooltipComponent.flagText(text, asexualColors, ticks);
            } else if (type.equals("aromantic")) {
                component = ImageClientTooltipComponent.flagText(text, aromanticColors, ticks);
            } else if (type.equals("aroace")) {
                component = ImageClientTooltipComponent.flagText(text, aroaceColors, ticks);
            } else if (type.equals("agender")) {
                component = ImageClientTooltipComponent.flagText(text, agenderColors, ticks);
            } else if (type.equals("bisexual")) {
                component = ImageClientTooltipComponent.flagText(text, bisexualColors, ticks);
            } else if (type.equals("demiboy")) {
                component = ImageClientTooltipComponent.flagText(text, demiboyColors, ticks);
            } else if (type.equals("demigender")) {
                component = ImageClientTooltipComponent.flagText(text, demigenderColors, ticks);
            } else if (type.equals("demigirl")) {
                component = ImageClientTooltipComponent.flagText(text, demigirlColors, ticks);
            } else if (type.equals("gay")) {
                component = ImageClientTooltipComponent.flagText(text, gayColors, ticks);
            } else if (type.equals("genderfluid")) {
                component = ImageClientTooltipComponent.flagText(text, genderfluidColors, ticks);
            } else if (type.equals("genderqueer")) {
                component = ImageClientTooltipComponent.flagText(text, genderqueerColors, ticks);
            } else if (type.equals("intersex")) {
                component = ImageClientTooltipComponent.flagText(text, intersexColors, ticks);
            } else if (type.equals("lesbian")) {
                component = ImageClientTooltipComponent.flagText(text, lesbianColors, ticks);
            } else if (type.equals("nonbinary")) {
                component = ImageClientTooltipComponent.flagText(text, nonbinaryColors, ticks);
            } else if (type.equals("pansexual")) {
                component = ImageClientTooltipComponent.flagText(text, pansexualColors, ticks);
            } else if (type.equals("trans")) {
                component = ImageClientTooltipComponent.flagText(text, transColors, ticks);
            }
        }
        return component;
    }

    public static MutableComponent flagText(String text, List<Integer> colors, int ticks) {
        MutableComponent component = Component.literal((String)"");
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            int color = ImageClientTooltipComponent.getCycledColor(colors, ticks + 3 * i);
            MutableComponent letter = Component.literal((String)String.valueOf(c)).withStyle(style -> style.withColor(color));
            component.append((Component)letter);
        }
        return component;
    }

    public static int getCycledColor(List<Integer> colors, int ticks) {
        if (colors == null || colors.isEmpty()) {
            return 0xFFFFFF;
        }
        if (colors.size() == 1) {
            return colors.get(0);
        }
        int holdTime = 20;
        int fadeTime = 20;
        int segmentTime = holdTime + fadeTime;
        int totalCycle = colors.size() * segmentTime;
        int time = ticks % totalCycle;
        int index = time / segmentTime;
        int local = time % segmentTime;
        int current = colors.get(index);
        int next = colors.get((index + 1) % colors.size());
        float t = 0.0f;
        if (local >= holdTime) {
            t = (float)(local - holdTime) / (float)fadeTime;
        }
        return ImageClientTooltipComponent.lerpColor(current, next, t);
    }

    private static int lerpColor(int c1, int c2, float t) {
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public int getRainbowColorFromTick(int ticks) {
        float speed = 0.05f;
        float red = Mth.clamp((float)((float)(Math.sin((float)ticks * speed) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
        float green = Mth.clamp((float)((float)(Math.sin((double)((float)ticks * speed) + 2.0943951023931953) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
        float blue = Mth.clamp((float)((float)(Math.sin((double)((float)ticks * speed) + 4.1887902047863905) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
        int truered = (int)(red * 255.0f);
        int truegreen = (int)(green * 255.0f);
        int trueblue = (int)(blue * 255.0f);
        return truered << 16 | truegreen << 8 | trueblue;
    }

    public int blendColors(int c1, int c2, float ratio) {
        ratio = Math.min(1.0f, Math.max(0.0f, ratio));
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 * ratio + (float)r2 * (1.0f - ratio));
        int g = (int)((float)g1 * ratio + (float)g2 * (1.0f - ratio));
        int b = (int)((float)b1 * ratio + (float)b2 * (1.0f - ratio));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

