/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.blocks;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xox.labvorty.weaversparadise.blocks.entities.DyemakingBlockEntity;
import xox.labvorty.weaversparadise.data.WeaversParadiseDyeHandler;
import xox.labvorty.weaversparadise.gui.menu.DyemakingMenu;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;

public class DyemakingBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public DyemakingBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(1.0f, 10.0f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> DyemakingBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
            case Direction.NORTH -> DyemakingBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
            case Direction.EAST -> DyemakingBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
            case Direction.WEST -> DyemakingBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public void onPlace(BlockState blockstate, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, level, pos, oldState, moving);
        level.scheduleTick(pos, (Block)this, 1);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Dyemaking");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new DyemakingMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    public void tick(BlockState blockstate, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        super.tick(blockstate, serverLevel, pos, random);
        BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
        if (blockEntity instanceof DyemakingBlockEntity) {
            int blue;
            int green;
            int red;
            boolean shouldOverrideDyeType;
            String dyeType;
            DyemakingBlockEntity dyemakingBlock = (DyemakingBlockEntity)blockEntity;
            ItemStack slot0 = dyemakingBlock.getItemHandler().getStackInSlot(0);
            ItemStack slot1 = dyemakingBlock.getItemHandler().getStackInSlot(1);
            ItemStack slot2 = dyemakingBlock.getItemHandler().getStackInSlot(2);
            ItemStack slot3 = dyemakingBlock.getItemHandler().getStackInSlot(3);
            ItemStack slot4 = dyemakingBlock.getItemHandler().getStackInSlot(4);
            ItemStack slot5 = dyemakingBlock.getItemHandler().getStackInSlot(5);
            ItemStack slot6 = dyemakingBlock.getItemHandler().getStackInSlot(6);
            ItemStack slot7 = dyemakingBlock.getItemHandler().getStackInSlot(7);
            ItemStack slot8 = dyemakingBlock.getItemHandler().getStackInSlot(8);
            ItemStack slot9 = dyemakingBlock.getItemHandler().getStackInSlot(9);
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(List.of(slot1, slot2, slot3, slot4, slot5, slot6, slot7, slot8, slot9));
            ItemStack slot10 = dyemakingBlock.getItemHandler().getStackInSlot(10);
            ItemStack slot11 = dyemakingBlock.getItemHandler().getStackInSlot(11);
            ItemStack slot12 = dyemakingBlock.getItemHandler().getStackInSlot(12);
            ArrayList<Integer> reds = new ArrayList<Integer>();
            ArrayList<Integer> greens = new ArrayList<Integer>();
            ArrayList<Integer> blues = new ArrayList<Integer>();
            if (slot12.is((Item)WeaversParadiseItems.DYE_CORE.get())) {
                dyeType = ((CustomData)slot12.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("dyeType");
                shouldOverrideDyeType = true;
            } else {
                dyeType = "default";
                shouldOverrideDyeType = false;
            }
            for (ItemStack itemStack : itemStacks) {
                if (!itemStack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"weaversparadise:vanilla_dyes")))) continue;
                WeaversParadiseDyeHandler dyeHandler = WeaversParadiseDyeHandler.getOrDefault(itemStack.getItem());
                reds.add(dyeHandler.getRed());
                greens.add(dyeHandler.getGreen());
                blues.add(dyeHandler.getBlue());
            }
            if (reds.size() > 0 && greens.size() > 0 && blues.size() > 0) {
                void var30_33;
                int redinst = 0;
                Iterator iterator = reds.iterator();
                while (iterator.hasNext()) {
                    int redcolor = (Integer)iterator.next();
                    redinst += redcolor;
                }
                red = redinst / reds.size();
                boolean bl = false;
                Iterator redcolor = greens.iterator();
                while (redcolor.hasNext()) {
                    int greencolor = (Integer)redcolor.next();
                    var30_33 += greencolor;
                }
                green = var30_33 / greens.size();
                int blueinst = 0;
                Iterator iterator2 = blues.iterator();
                while (iterator2.hasNext()) {
                    int bluecolor = (Integer)iterator2.next();
                    blueinst += bluecolor;
                }
                blue = blueinst / blues.size();
            } else {
                red = 0;
                green = 0;
                blue = 0;
            }
            if (slot10.is(Items.GLASS_BOTTLE) && slot11.is(Items.POTION)) {
                ItemStack stack = new ItemStack((ItemLike)WeaversParadiseItems.BOTTLED_DYE.get());
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
                    tag.putInt("colorRedOne", red);
                    tag.putInt("colorGreenOne", green);
                    tag.putInt("colorBlueOne", blue);
                    if (shouldOverrideDyeType) {
                        tag.putString("dyeType", dyeType);
                    }
                });
                dyemakingBlock.getItemHandler().setStackInSlot(0, stack);
            } else if (slot10.is(Items.GLASS_BOTTLE) && slot11.is((Item)WeaversParadiseItems.BOTTLED_DYE.get())) {
                ItemStack stack = slot11.copy();
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
                    tag.putInt("colorRedTwo", red);
                    tag.putInt("colorGreenTwo", green);
                    tag.putInt("colorBlueTwo", blue);
                    if (shouldOverrideDyeType) {
                        tag.putString("dyeType", dyeType);
                    }
                });
                dyemakingBlock.getItemHandler().setStackInSlot(0, stack);
            } else {
                dyemakingBlock.getItemHandler().setStackInSlot(0, ItemStack.EMPTY);
            }
        }
        serverLevel.scheduleTick(pos, (Block)this, 1);
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DyemakingBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof DyemakingBlockEntity) {
                DyemakingBlockEntity be = (DyemakingBlockEntity)blockEntity;
                for (int i = 1; i <= 12; ++i) {
                    ItemStack stack = be.getItemHandler().getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
                }
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof DyemakingBlockEntity) {
            DyemakingBlockEntity be = (DyemakingBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

