/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class WeaversParadiseQualityResultRecipe
extends ShapedRecipe {
    public WeaversParadiseQualityResultRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registrie) {
        ItemStack stack = super.assemble(input, registrie);
        int qualityItems = 0;
        int resultQuality = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack inputStack = input.getItem(i);
            CompoundTag compound = ((CustomData)inputStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (!compound.contains("quality")) continue;
            ++qualityItems;
            resultQuality += compound.getInt("quality");
        }
        int finalQuality = resultQuality / qualityItems;
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putInt("quality", finalQuality));
        return stack;
    }

    public static class QualityResultRecipeSerializer
    implements RecipeSerializer<WeaversParadiseQualityResultRecipe> {
        public static final QualityResultRecipeSerializer INSTANCE = new QualityResultRecipeSerializer();
        private final MapCodec<WeaversParadiseQualityResultRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShapedRecipe.Serializer.CODEC.forGetter(recipe -> new ShapedRecipe(recipe.getGroup(), recipe.category(), recipe.pattern, recipe.getResultItem(null), recipe.showNotification()))).apply((Applicative)instance, shapedRecipe -> new WeaversParadiseQualityResultRecipe(shapedRecipe.getGroup(), shapedRecipe.category(), shapedRecipe.pattern, shapedRecipe.getResultItem(null), shapedRecipe.showNotification())));
        private final StreamCodec<RegistryFriendlyByteBuf, WeaversParadiseQualityResultRecipe> STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);

        public MapCodec<WeaversParadiseQualityResultRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WeaversParadiseQualityResultRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        public WeaversParadiseQualityResultRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.streamCodec().decode((Object)buffer);
            return new WeaversParadiseQualityResultRecipe(shapedRecipe.getGroup(), shapedRecipe.category(), shapedRecipe.pattern, shapedRecipe.getResultItem(null), shapedRecipe.showNotification());
        }

        public void toNetwork(RegistryFriendlyByteBuf buffer, WeaversParadiseQualityResultRecipe recipe) {
            RecipeSerializer.SHAPED_RECIPE.streamCodec().encode((Object)buffer, (Object)recipe);
        }
    }
}

