/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.data;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import xox.labvorty.weaversparadise.items.HandWarmersCotton;
import xox.labvorty.weaversparadise.items.HandWarmersSilk;
import xox.labvorty.weaversparadise.items.HandWarmersWool;
import xox.labvorty.weaversparadise.items.ShirtCotton;
import xox.labvorty.weaversparadise.items.ShirtSilk;
import xox.labvorty.weaversparadise.items.SweaterWool;
import xox.labvorty.weaversparadise.items.ThighHighsCotton;
import xox.labvorty.weaversparadise.items.ThighHighsSilk;
import xox.labvorty.weaversparadise.items.ThighHighsWool;

public class WeaversParadiseStatHandler {
    private static final String SLOT_LEGWEAR = "legwear";
    private static final String SLOT_GLOVES = "gloves";
    private static final String SLOT_UPPERWEAR = "upperwear";
    private static final String COTTON = "cotton";
    private static final String SILK = "silk";
    private static final String WOOL = "wool";

    public Pair<String, Double> calculateType(LivingEntity livingEntity) {
        return WeaversParadiseStatHandler.calculateTypeInternal(livingEntity);
    }

    public static Pair<String, Double> calculateStaticType(LivingEntity livingEntity) {
        return WeaversParadiseStatHandler.calculateTypeInternal(livingEntity);
    }

    private static Pair<String, Double> calculateTypeInternal(LivingEntity livingEntity) {
        MaterialCount counts = new MaterialCount();
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)livingEntity);
        if (curiosInventory.isPresent()) {
            WeaversParadiseStatHandler.processSlotType((ICuriosItemHandler)curiosInventory.get(), livingEntity, SLOT_LEGWEAR, counts);
            WeaversParadiseStatHandler.processSlotType((ICuriosItemHandler)curiosInventory.get(), livingEntity, SLOT_GLOVES, counts);
            WeaversParadiseStatHandler.processSlotType((ICuriosItemHandler)curiosInventory.get(), livingEntity, SLOT_UPPERWEAR, counts);
        }
        return WeaversParadiseStatHandler.determineDominantMaterial(counts);
    }

    private static void processSlotType(ICuriosItemHandler handler, LivingEntity livingEntity, String slotType, MaterialCount counts) {
        ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get(slotType);
        if (stacksHandler == null) {
            return;
        }
        for (int i = 0; i < stacksHandler.getSlots(); ++i) {
            ItemStack itemStack = stacksHandler.getStacks().getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            WeaversParadiseStatHandler.classifyItem(itemStack, counts);
        }
    }

    private static void classifyItem(ItemStack itemStack, MaterialCount counts) {
        if (itemStack.getItem() instanceof ThighHighsCotton || itemStack.getItem() instanceof HandWarmersCotton || itemStack.getItem() instanceof ShirtCotton) {
            counts.cotton += 1.0;
            counts.total += 1.0;
        } else if (itemStack.getItem() instanceof ThighHighsSilk || itemStack.getItem() instanceof HandWarmersSilk || itemStack.getItem() instanceof ShirtSilk) {
            counts.silk += 1.0;
            counts.total += 1.0;
        } else if (itemStack.getItem() instanceof ThighHighsWool || itemStack.getItem() instanceof HandWarmersWool || itemStack.getItem() instanceof SweaterWool) {
            counts.wool += 1.0;
            counts.total += 1.0;
        }
    }

    private static Pair<String, Double> determineDominantMaterial(MaterialCount counts) {
        if (counts.total == 0.0) {
            return new Pair((Object)"", (Object)0.0);
        }
        if (counts.cotton >= counts.silk && counts.cotton >= counts.wool) {
            return new Pair((Object)COTTON, (Object)(counts.cotton / counts.total));
        }
        if (counts.silk >= counts.wool) {
            return new Pair((Object)SILK, (Object)(counts.silk / counts.total));
        }
        return new Pair((Object)WOOL, (Object)(counts.wool / counts.total));
    }

    private static class MaterialCount {
        double cotton = 0.0;
        double silk = 0.0;
        double wool = 0.0;
        double total = 0.0;

        private MaterialCount() {
        }
    }
}

