/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;
import xox.labvorty.weaversparadise.items.LeatherGloves;

public class CottonBush
extends CropBlock {
    public static final MapCodec<CottonBush> CODEC = CottonBush.simpleCodec(CottonBush::new);
    public static final int MAX_AGE = 6;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)6);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)6.0, (double)-1.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)6.0, (double)-1.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)5.0, (double)-1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)};

    public CottonBush(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 6;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)WeaversParadiseItems.COTTON_SEEDS.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        Optional handler = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (handler.isPresent() && (Integer)state.getValue((Property)AGE) == 6) {
            if (((ICuriosItemHandler)handler.get()).isEquipped(stack -> {
                Item patt0$temp = stack.getItem();
                if (patt0$temp instanceof LeatherGloves) {
                    LeatherGloves leatherGloves = (LeatherGloves)patt0$temp;
                    return true;
                }
                return false;
            })) {
                LeatherGloves leatherGloves;
                RandomSource randomSource = RandomSource.create();
                SlotResult slotResult = (SlotResult)((ICuriosItemHandler)handler.get()).findFirstCurio((Item)WeaversParadiseItems.LEATHER_GLOVES.get()).get();
                ItemStack stack2 = slotResult.stack();
                Item item = stack2.getItem();
                if (item instanceof LeatherGloves && (leatherGloves = (LeatherGloves)item).shouldReceiveDamage(stack2, randomSource)) {
                    stack2.setDamageValue(stack2.getDamageValue() + 1);
                    ((ICuriosItemHandler)handler.get()).setEquippedCurio(slotResult.slotContext().identifier(), slotResult.slotContext().index(), stack2);
                }
            } else {
                player.hurt(level.damageSources().cactus(), 1.0f);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }
}

