/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class DyeCrushingRecipe
extends ShapelessRecipe {
    private final int red;
    private final int green;
    private final int blue;

    public DyeCrushingRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients, int red, int green, int blue) {
        super(group, category, result, ingredients);
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack stack = super.assemble(input, registries).copy();
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
            tag.putInt("red", this.red);
            tag.putInt("green", this.green);
            tag.putInt("blue", this.blue);
        });
        return stack;
    }

    public static class DyeCrushingRecipeSerializer
    implements RecipeSerializer<DyeCrushingRecipe> {
        public static final DyeCrushingRecipeSerializer INSTANCE = new DyeCrushingRecipeSerializer();
        private static final MapCodec<DyeCrushingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapelessRecipe::category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.getResultItem(null)), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            if (ingredients.isEmpty()) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            if (ingredients.size() > 9) {
                return DataResult.error(() -> "Too many ingredients for shapeless recipe. Maximum is 9");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new))));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients), (App)Codec.INT.fieldOf("red").forGetter(DyeCrushingRecipe::getRed), (App)Codec.INT.fieldOf("green").forGetter(DyeCrushingRecipe::getGreen), (App)Codec.INT.fieldOf("blue").forGetter(DyeCrushingRecipe::getBlue)).apply((Applicative)instance, DyeCrushingRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, DyeCrushingRecipe> STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);

        public MapCodec<DyeCrushingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DyeCrushingRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private DyeCrushingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int ingredientsSize = buffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)ingredientsSize, (Object)Ingredient.EMPTY);
            for (int i = 0; i < ingredientsSize; ++i) {
                ingredients.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            int red = buffer.readVarInt();
            int green = buffer.readVarInt();
            int blue = buffer.readVarInt();
            return new DyeCrushingRecipe(group, category, result, (NonNullList<Ingredient>)ingredients, red, green, blue);
        }

        private void toNetwork(RegistryFriendlyByteBuf buffer, DyeCrushingRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResultItem(null));
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            buffer.writeVarInt(recipe.getRed());
            buffer.writeVarInt(recipe.getGreen());
            buffer.writeVarInt(recipe.getBlue());
        }
    }
}

