/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.blocks;

import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import xox.labvorty.weaversparadise.blocks.entities.SpinningJennyBlockEntity;
import xox.labvorty.weaversparadise.gui.menu.StringMenu;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;
import xox.labvorty.weaversparadise.items.EmptySpool;

public class SpinningJennyBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public SpinningJennyBlock() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.NORMAL).sound(SoundType.WOOD).strength(1.0f, 10.0f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"String Block");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new StringMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 1);
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SpinningJennyBlockEntity(pos, state);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        ItemStack mainStack = new Object(this){

            public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                ILevelExtension _ext;
                IItemHandler itemHandler;
                if (world instanceof ILevelExtension && (itemHandler = (IItemHandler)(_ext = (ILevelExtension)world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
                    return itemHandler.getStackInSlot(slotid).copy();
                }
                return ItemStack.EMPTY;
            }
        }.getItemStack((LevelAccessor)world, pos, 0);
        ItemStack stack1 = new Object(this){

            public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                ILevelExtension _ext;
                IItemHandler itemHandler;
                if (world instanceof ILevelExtension && (itemHandler = (IItemHandler)(_ext = (ILevelExtension)world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
                    return itemHandler.getStackInSlot(slotid).copy();
                }
                return ItemStack.EMPTY;
            }
        }.getItemStack((LevelAccessor)world, pos, 1);
        ItemStack stack2 = new Object(this){

            public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                ILevelExtension _ext;
                IItemHandler itemHandler;
                if (world instanceof ILevelExtension && (itemHandler = (IItemHandler)(_ext = (ILevelExtension)world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
                    return itemHandler.getStackInSlot(slotid).copy();
                }
                return ItemStack.EMPTY;
            }
        }.getItemStack((LevelAccessor)world, pos, 2);
        ItemStack stack3 = new Object(this){

            public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                ILevelExtension _ext;
                IItemHandler itemHandler;
                if (world instanceof ILevelExtension && (itemHandler = (IItemHandler)(_ext = (ILevelExtension)world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
                    return itemHandler.getStackInSlot(slotid).copy();
                }
                return ItemStack.EMPTY;
            }
        }.getItemStack((LevelAccessor)world, pos, 3);
        ItemStack stack4 = new Object(this){

            public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                ILevelExtension _ext;
                IItemHandler itemHandler;
                if (world instanceof ILevelExtension && (itemHandler = (IItemHandler)(_ext = (ILevelExtension)world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
                    return itemHandler.getStackInSlot(slotid).copy();
                }
                return ItemStack.EMPTY;
            }
        }.getItemStack((LevelAccessor)world, pos, 4);
        ItemStack stack5 = new Object(this){

            public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                ILevelExtension _ext;
                IItemHandler itemHandler;
                if (world instanceof ILevelExtension && (itemHandler = (IItemHandler)(_ext = (ILevelExtension)world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
                    return itemHandler.getStackInSlot(slotid).copy();
                }
                return ItemStack.EMPTY;
            }
        }.getItemStack((LevelAccessor)world, pos, 5);
        ItemStack stack6 = new Object(this){

            public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                ILevelExtension _ext;
                IItemHandler itemHandler;
                if (world instanceof ILevelExtension && (itemHandler = (IItemHandler)(_ext = (ILevelExtension)world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
                    return itemHandler.getStackInSlot(slotid).copy();
                }
                return ItemStack.EMPTY;
            }
        }.getItemStack((LevelAccessor)world, pos, 6);
        BlockEntity bEntity = world.getBlockEntity(pos);
        int state = 0;
        boolean canChange = false;
        if (bEntity instanceof SpinningJennyBlockEntity) {
            SpinningJennyBlockEntity spinningJennyBE = (SpinningJennyBlockEntity)bEntity;
            state = spinningJennyBE.getWorkingState();
            if (this.hasCraftItems(stack1, mainStack) || this.hasCraftItems(stack2, mainStack) || this.hasCraftItems(stack3, mainStack) || this.hasCraftItems(stack4, mainStack) || this.hasCraftItems(stack5, mainStack) || this.hasCraftItems(stack6, mainStack)) {
                canChange = true;
            } else {
                state = 0;
                spinningJennyBE.setWorkingState(0);
            }
        }
        if (state >= 100) {
            IItemHandlerModifiable itemHandlerModifiable;
            Item _ext;
            Object object;
            EmptySpool emptyWoolSpool;
            if (mainStack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:wool")))) {
                Item item = stack1.getItem();
                if (item instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)item;
                    if (mainStack.getCount() > 0 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(1, new ItemStack((ItemLike)WeaversParadiseItems.WOOL_SPOOL.get()));
                        mainStack.shrink(1);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack2.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 0 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(2, new ItemStack((ItemLike)WeaversParadiseItems.WOOL_SPOOL.get()));
                        mainStack.shrink(1);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack3.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 0 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(3, new ItemStack((ItemLike)WeaversParadiseItems.WOOL_SPOOL.get()));
                        mainStack.shrink(1);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack4.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 0 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(4, new ItemStack((ItemLike)WeaversParadiseItems.WOOL_SPOOL.get()));
                        mainStack.shrink(1);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack5.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 0 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(5, new ItemStack((ItemLike)WeaversParadiseItems.WOOL_SPOOL.get()));
                        mainStack.shrink(1);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack6.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 0 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(6, new ItemStack((ItemLike)WeaversParadiseItems.WOOL_SPOOL.get()));
                        mainStack.shrink(1);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
            }
            if (mainStack.is(Items.STRING)) {
                _ext = stack1.getItem();
                if (_ext instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 4 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(1, new ItemStack((ItemLike)WeaversParadiseItems.SILK_SPOOL.get()));
                        mainStack.shrink(5);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack2.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 4 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(2, new ItemStack((ItemLike)WeaversParadiseItems.SILK_SPOOL.get()));
                        mainStack.shrink(5);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack3.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 4 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(3, new ItemStack((ItemLike)WeaversParadiseItems.SILK_SPOOL.get()));
                        mainStack.shrink(5);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack4.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 4 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(4, new ItemStack((ItemLike)WeaversParadiseItems.SILK_SPOOL.get()));
                        mainStack.shrink(5);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack5.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 4 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(5, new ItemStack((ItemLike)WeaversParadiseItems.SILK_SPOOL.get()));
                        mainStack.shrink(5);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack6.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 4 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(6, new ItemStack((ItemLike)WeaversParadiseItems.SILK_SPOOL.get()));
                        mainStack.shrink(5);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
            }
            if (mainStack.is(WeaversParadiseItems.RAW_COTTON)) {
                _ext = stack1.getItem();
                if (_ext instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 3 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(1, new ItemStack((ItemLike)WeaversParadiseItems.COTTON_SPOOL.get()));
                        mainStack.shrink(4);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack2.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 3 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(2, new ItemStack((ItemLike)WeaversParadiseItems.COTTON_SPOOL.get()));
                        mainStack.shrink(4);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack3.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 3 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(3, new ItemStack((ItemLike)WeaversParadiseItems.COTTON_SPOOL.get()));
                        mainStack.shrink(4);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack4.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 3 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(4, new ItemStack((ItemLike)WeaversParadiseItems.COTTON_SPOOL.get()));
                        mainStack.shrink(4);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack5.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 3 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(5, new ItemStack((ItemLike)WeaversParadiseItems.COTTON_SPOOL.get()));
                        mainStack.shrink(4);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
                if ((_ext = stack6.getItem()) instanceof EmptySpool) {
                    emptyWoolSpool = (EmptySpool)_ext;
                    if (mainStack.getCount() > 3 && world instanceof ILevelExtension && (object = (_ext = world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable) {
                        itemHandlerModifiable = (IItemHandlerModifiable)object;
                        itemHandlerModifiable.setStackInSlot(6, new ItemStack((ItemLike)WeaversParadiseItems.COTTON_SPOOL.get()));
                        mainStack.shrink(4);
                        itemHandlerModifiable.setStackInSlot(0, mainStack);
                    }
                }
            }
            if (canChange && bEntity instanceof SpinningJennyBlockEntity) {
                spinningJennyBlockEntity = (SpinningJennyBlockEntity)bEntity;
                spinningJennyBlockEntity.setWorkingState(0);
            }
        } else if (canChange && bEntity instanceof SpinningJennyBlockEntity) {
            spinningJennyBlockEntity = (SpinningJennyBlockEntity)bEntity;
            spinningJennyBlockEntity.setWorkingState(state + 1);
        }
        world.scheduleTick(pos, (Block)this, 1);
    }

    public boolean hasCraftItems(ItemStack stack, ItemStack mainStack) {
        if (mainStack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:wool"))) && mainStack.getCount() > 0 && stack.is((Item)WeaversParadiseItems.EMPTY_SPOOL.get())) {
            return true;
        }
        if (mainStack.is(Items.STRING) && mainStack.getCount() > 4 && stack.is((Item)WeaversParadiseItems.EMPTY_SPOOL.get())) {
            return true;
        }
        return mainStack.is((Item)WeaversParadiseItems.RAW_COTTON.get()) && mainStack.getCount() > 3 && stack.is((Item)WeaversParadiseItems.EMPTY_SPOOL.get());
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof SpinningJennyBlockEntity) {
                SpinningJennyBlockEntity be = (SpinningJennyBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof SpinningJennyBlockEntity) {
            SpinningJennyBlockEntity be = (SpinningJennyBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> SpinningJennyBlock.box((double)1.0, (double)0.01, (double)0.0, (double)15.0, (double)13.0, (double)15.0);
            case Direction.NORTH -> SpinningJennyBlock.box((double)1.0, (double)0.01, (double)1.0, (double)15.0, (double)13.0, (double)16.0);
            case Direction.EAST -> SpinningJennyBlock.box((double)0.0, (double)0.01, (double)1.0, (double)15.0, (double)13.0, (double)15.0);
            case Direction.WEST -> SpinningJennyBlock.box((double)1.0, (double)0.01, (double)1.0, (double)16.0, (double)13.0, (double)15.0);
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

