/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.data;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;

public class WeaversParadiseDyeCoreUpgradeRecipe
extends ShapelessRecipe {
    public WeaversParadiseDyeCoreUpgradeRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(group, category, result, ingredients);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack stack = super.assemble(input, registries);
        int redstones = 0;
        boolean isGlowstone = false;
        boolean isRedstone = false;
        boolean isAbleToModify = false;
        for (int i = 0; i < input.size(); ++i) {
            if (input.getItem(i).is(Items.REDSTONE)) {
                ++redstones;
            }
            if (input.getItem(i).is(WeaversParadiseItems.DYE_CORE)) {
                CompoundTag compoundTag = ((CustomData)input.getItem(i).getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                if (compoundTag.getString("dyeType").equals("lamp") || compoundTag.getString("dyeType").equals("redstone")) {
                    isAbleToModify = true;
                }
                if (compoundTag.getString("dyeType").equals("redstone")) {
                    isRedstone = true;
                }
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
                    tag.putString("dyeType", compoundTag.getString("dyeType"));
                    tag.putInt("lightValue", compoundTag.getInt("lightValue"));
                });
            }
            if (!input.getItem(i).is(Items.GLOWSTONE_DUST)) continue;
            isGlowstone = true;
        }
        if (isAbleToModify && (isGlowstone && isRedstone || redstones > 0)) {
            CompoundTag compoundTag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            String dyeType = isGlowstone && isRedstone ? "lamp" : compoundTag.getString("dyeType");
            int modifiedLightValue = Mth.clamp((int)(compoundTag.getInt("lightValue") + redstones), (int)0, (int)15);
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
                tag.putString("dyeType", dyeType);
                tag.putInt("lightValue", modifiedLightValue);
            });
        }
        return stack;
    }

    public static class DyeCoreUpgadeRecipeSerializer
    implements RecipeSerializer<WeaversParadiseDyeCoreUpgradeRecipe> {
        public static DyeCoreUpgadeRecipeSerializer INSTANCE = new DyeCoreUpgadeRecipeSerializer();
        private final StreamCodec<RegistryFriendlyByteBuf, WeaversParadiseDyeCoreUpgradeRecipe> STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);

        public MapCodec<WeaversParadiseDyeCoreUpgradeRecipe> codec() {
            return RecipeSerializer.SHAPELESS_RECIPE.codec().xmap(recipe -> new WeaversParadiseDyeCoreUpgradeRecipe(recipe.getGroup(), recipe.category(), recipe.getResultItem(null), (NonNullList<Ingredient>)recipe.getIngredients()), recipe -> recipe);
        }

        public StreamCodec<RegistryFriendlyByteBuf, WeaversParadiseDyeCoreUpgradeRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private WeaversParadiseDyeCoreUpgradeRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ShapelessRecipe vanilla = (ShapelessRecipe)RecipeSerializer.SHAPELESS_RECIPE.streamCodec().decode((Object)buffer);
            return new WeaversParadiseDyeCoreUpgradeRecipe(vanilla.getGroup(), vanilla.category(), vanilla.getResultItem(null), (NonNullList<Ingredient>)vanilla.getIngredients());
        }

        public void toNetwork(RegistryFriendlyByteBuf buffer, WeaversParadiseDyeCoreUpgradeRecipe recipe) {
            RecipeSerializer.SHAPELESS_RECIPE.streamCodec().encode((Object)buffer, (Object)recipe);
        }
    }
}

