/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.data;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public enum WeaversParadiseDyeHandler {
    WHITE("White", Items.WHITE_DYE, 249, 255, 254),
    LIGHT_GRAY("Light Gray", Items.LIGHT_GRAY_DYE, 157, 157, 151),
    GRAY("Gray", Items.GRAY_DYE, 71, 79, 82),
    BLACK("Black", Items.BLACK_DYE, 29, 29, 33),
    BROWN("Brown", Items.BROWN_DYE, 131, 84, 50),
    RED("Red", Items.RED_DYE, 176, 46, 38),
    ORANGE("Orange", Items.ORANGE_DYE, 249, 128, 29),
    YELLOW("Yellow", Items.YELLOW_DYE, 254, 216, 61),
    LIME("Lime", Items.LIME_DYE, 128, 199, 31),
    GREEN("Green", Items.GREEN_DYE, 94, 124, 22),
    CYAN("Cyan", Items.CYAN_DYE, 22, 156, 156),
    LIGHT_BLUE("Light Blue", Items.LIGHT_BLUE_DYE, 58, 179, 218),
    BLUE("Blue", Items.BLUE_DYE, 60, 68, 170),
    PURPLE("Purple", Items.PURPLE_DYE, 137, 50, 184),
    MAGENTA("Magenta", Items.MAGENTA_DYE, 199, 78, 189),
    PINK("Pink", Items.PINK_DYE, 243, 139, 170);

    private final String name;
    private final int red;
    private final int green;
    private final int blue;
    private final Item instance;
    private static final Map<Item, WeaversParadiseDyeHandler> HANDLER_MAP;

    private WeaversParadiseDyeHandler(String name, Item instance, int red, int green, int blue) {
        this.name = name;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.instance = instance;
    }

    public String getName() {
        return this.name;
    }

    public Item getInstance() {
        return this.instance;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getColor() {
        return 0xFF000000 | this.red << 16 | this.green << 8 | this.blue;
    }

    public static WeaversParadiseDyeHandler getOrDefault(Item item) {
        return HANDLER_MAP.getOrDefault(item, WHITE);
    }

    static {
        HANDLER_MAP = Stream.of(WeaversParadiseDyeHandler.values()).collect(Collectors.toMap(WeaversParadiseDyeHandler::getInstance, e -> e));
    }
}

