/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import xox.labvorty.weaversparadise.data.ClothcraftingNetworkMultiMessage;
import xox.labvorty.weaversparadise.gui.menu.ClothcraftingMenu;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;
import xox.labvorty.weaversparadise.init.WeaversParadiseKeyMappings;
import xox.labvorty.weaversparadise.items.CottonSpool;
import xox.labvorty.weaversparadise.items.SilkSpool;
import xox.labvorty.weaversparadise.items.WoolSpool;

@OnlyIn(value=Dist.CLIENT)
public class ClothcraftingScreen
extends AbstractContainerScreen<ClothcraftingMenu> {
    private static final HashMap<String, Object> guistate = ClothcraftingMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private static int gameTime = 0;
    private static boolean gameStarted = false;
    private static int gameScore = 0;
    private static List<ItemStack> items = new ArrayList<ItemStack>();
    private ImageButton startMinigame;
    private ImageButton claimItems;
    private int upColoredTime = 0;
    private int rightColoredTime = 0;
    private int downColoredTime = 0;
    private int leftColoredTime = 0;
    private String previewL1One = "";
    private String previewL1Two = "";
    private String previewL1Three = "";
    private String previewL1Four = "";
    private String previewL1Five = "";
    private String previewL2One = "";
    private String previewL2Two = "";
    private String previewL2Three = "";
    private String previewL2Four = "";
    private String previewL2Five = "";
    private String previewL3One = "";
    private String previewL3Two = "";
    private String previewL3Three = "";
    private String previewL3Four = "";
    private String previewL3Five = "";
    private String previewL4One = "";
    private String previewL4Two = "";
    private String previewL4Three = "";
    private String previewL4Four = "";
    private String previewL4Five = "";
    private String pretypeOne = "";
    private String pretypeTwo = "";
    private String pretypeThree = "";
    private String pretypeFour = "";
    private String pretypeFive = "";
    private String inputOne = "";
    private String inputTwo = "";
    private String inputThree = "";
    private String inputFour = "";
    private String inputFive = "";
    private static String clothType = "";

    public static void updateData(int time, int score, boolean ison, List<ItemStack> item, String type) {
        gameTime = time;
        gameScore = score;
        gameStarted = ison;
        items = item;
        clothType = type;
    }

    public ClothcraftingScreen(ClothcraftingMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 209;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (gameStarted) {
            this.renderMiniGame(guiGraphics, partialTicks, mouseX, mouseY);
        } else {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.renderTooltip(guiGraphics, mouseX, mouseY);
            PoseStack poseStack = guiGraphics.pose();
            String startButtonText = Component.translatable((String)"weaversparadise.clothcrafting.start_button").getString();
            float startButtonScale = 1.0f;
            if (this.font.width(startButtonText) > 66) {
                startButtonScale = 66.0f / (float)this.font.width(startButtonText);
            }
            poseStack.pushPose();
            poseStack.scale(startButtonScale, startButtonScale, startButtonScale);
            poseStack.translate(((double)this.leftPos + 38.5) / (double)startButtonScale, (double)(((float)(this.topPos + 104) + 5.0f * (1.0f - startButtonScale)) / startButtonScale), 1.0);
            guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)startButtonText), 0, 0, 0xFFFFFF);
            poseStack.popPose();
            String claimItemsText = Component.translatable((String)"weaversparadise.clothcrafting.claim_items").getString();
            float claimItemsScale = 1.0f;
            if (this.font.width(claimItemsText) > 66) {
                claimItemsScale = 66.0f / (float)this.font.width(claimItemsText);
            }
            poseStack.pushPose();
            poseStack.scale(claimItemsScale, claimItemsScale, claimItemsScale);
            poseStack.translate(((double)(this.leftPos + 99) + 35.5) / (double)claimItemsScale, (double)(((float)(this.topPos + 104) + 5.0f * (1.0f - claimItemsScale)) / claimItemsScale), 1.0);
            guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)claimItemsText), 0, 0, 0xFFFFFF);
            poseStack.popPose();
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (gx >= this.leftPos + 99 && gx <= this.leftPos + 99 + 72 && gy >= this.topPos + 96 && gy <= this.topPos + 96 + 25) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            for (ItemStack itemStack : items) {
                if (itemStack.getItem().equals(WeaversParadiseItems.COTTON_CLOTH.get()) || itemStack.getItem().equals(WeaversParadiseItems.WOOL_CLOTH.get()) || itemStack.getItem().equals(WeaversParadiseItems.SILK_CLOTH.get())) {
                    int quality = ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("quality");
                    components.add(Component.literal((String)(itemStack.getItem().getName(itemStack).getString() + " Q" + quality + " x" + itemStack.getCount())));
                    continue;
                }
                components.add(Component.literal((String)(itemStack.getItem().getName(itemStack).getString() + " x" + itemStack.getCount())));
            }
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), gx, gy);
        }
        guiGraphics.blit(ResourceLocation.parse((String)"weaversparadise:textures/screens/clothcrafting_main.png"), this.leftPos, this.topPos, 0.0f, 0.0f, 192, 209, 192, 209);
        RenderSystem.disableBlend();
    }

    public String renderArrowsMainHelper(String text) {
        switch (text) {
            case "UP": {
                return "weaversparadise:textures/screens/clothcrafting_input_support_u.png";
            }
            case "LEFT": {
                return "weaversparadise:textures/screens/clothcrafting_input_support_l.png";
            }
            case "DOWN": {
                return "weaversparadise:textures/screens/clothcrafting_input_support_d.png";
            }
            case "RIGHT": {
                return "weaversparadise:textures/screens/clothcrafting_input_support_r.png";
            }
        }
        return "weaversparadise:textures/screens/clothcrafting_input_support_u.png";
    }

    public String renderInputAssist(String main, String input) {
        if (!main.isBlank()) {
            if (main.equals(input)) {
                return "weaversparadise:textures/screens/clothcrafting_input_filled.png";
            }
            return "weaversparadise:textures/screens/clothcrafting_input_empty.png";
        }
        return "weaversparadise:textures/screens/clothcrafting_input_empty.png";
    }

    public String assistersRender(String text) {
        switch (text) {
            case "UP": {
                return "weaversparadise:textures/screens/clothcrafting_input_future_u.png";
            }
            case "LEFT": {
                return "weaversparadise:textures/screens/clothcrafting_input_future_l.png";
            }
            case "DOWN": {
                return "weaversparadise:textures/screens/clothcrafting_input_future_d.png";
            }
            case "RIGHT": {
                return "weaversparadise:textures/screens/clothcrafting_input_future_r.png";
            }
        }
        return "weaversparadise:textures/screens/clothcrafting_input_future_u.png";
    }

    protected void renderMiniGame(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        PoseStack poseStack = guiGraphics.pose();
        int minRed = 0;
        int minGreen = 255;
        int minBlue = 0;
        int maxRed = 255;
        int maxGreen = 255;
        int maxBlue = 255;
        int totalSeconds = gameTime / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        guiGraphics.blit(ResourceLocation.parse((String)"weaversparadise:textures/screens/clothcrafting_minigame.png"), this.leftPos - 38, this.topPos - 26, 0.0f, 0.0f, 269, 255, 269, 255);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)(Component.translatable((String)"weaversparadise.clothcrafting.time").getString() + " " + String.format("%02d:%02d", minutes, seconds))), this.leftPos + 10, this.topPos - 8, 0, false);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)(Component.translatable((String)"weaversparadise.clothcrafting.score").getString() + " " + gameScore)), this.leftPos - 38 + 183, this.topPos - 6, 0xFFFFFF, false);
        guiGraphics.blit(ResourceLocation.parse((String)this.renderInputAssist(this.pretypeOne, this.inputOne)), this.leftPos - 3, this.topPos + 135, 0.0f, 0.0f, 39, 39, 39, 39);
        guiGraphics.blit(ResourceLocation.parse((String)this.renderInputAssist(this.pretypeTwo, this.inputTwo)), this.leftPos - 38 + 76, this.topPos + 135, 0.0f, 0.0f, 39, 39, 39, 39);
        guiGraphics.blit(ResourceLocation.parse((String)this.renderInputAssist(this.pretypeThree, this.inputThree)), this.leftPos - 38 + 117, this.topPos + 135, 0.0f, 0.0f, 39, 39, 39, 39);
        guiGraphics.blit(ResourceLocation.parse((String)this.renderInputAssist(this.pretypeFour, this.inputFour)), this.leftPos - 38 + 158, this.topPos + 135, 0.0f, 0.0f, 39, 39, 39, 39);
        guiGraphics.blit(ResourceLocation.parse((String)this.renderInputAssist(this.pretypeFive, this.inputFive)), this.leftPos - 38 + 199, this.topPos + 135, 0.0f, 0.0f, 39, 39, 39, 39);
        guiGraphics.blit(ResourceLocation.parse((String)this.renderArrowsMainHelper(this.pretypeOne)), this.leftPos - 3, this.topPos + 135, 0.0f, 0.0f, 39, 39, 39, 39);
        guiGraphics.blit(ResourceLocation.parse((String)this.renderArrowsMainHelper(this.pretypeTwo)), this.leftPos - 38 + 76, this.topPos + 135, 0.0f, 0.0f, 39, 39, 39, 39);
        guiGraphics.blit(ResourceLocation.parse((String)this.renderArrowsMainHelper(this.pretypeThree)), this.leftPos - 38 + 117, this.topPos + 135, 0.0f, 0.0f, 39, 39, 39, 39);
        guiGraphics.blit(ResourceLocation.parse((String)this.renderArrowsMainHelper(this.pretypeFour)), this.leftPos - 38 + 158, this.topPos + 135, 0.0f, 0.0f, 39, 39, 39, 39);
        guiGraphics.blit(ResourceLocation.parse((String)this.renderArrowsMainHelper(this.pretypeFive)), this.leftPos - 38 + 199, this.topPos + 135, 0.0f, 0.0f, 39, 39, 39, 39);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL1One)), this.leftPos - 38 + 75, this.topPos - 26 + 128, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL1Two)), this.leftPos - 38 + 100, this.topPos - 26 + 128, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL1Three)), this.leftPos - 38 + 125, this.topPos - 26 + 128, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL1Four)), this.leftPos - 38 + 150, this.topPos - 26 + 128, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL1Five)), this.leftPos - 38 + 175, this.topPos - 26 + 128, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL2One)), this.leftPos - 38 + 75, this.topPos - 26 + 103, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL2Two)), this.leftPos - 38 + 100, this.topPos - 26 + 103, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL2Three)), this.leftPos - 38 + 125, this.topPos - 26 + 103, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL2Four)), this.leftPos - 38 + 150, this.topPos - 26 + 103, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL2Five)), this.leftPos - 38 + 175, this.topPos - 26 + 103, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL3One)), this.leftPos - 38 + 75, this.topPos - 26 + 78, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL3Two)), this.leftPos - 38 + 100, this.topPos - 26 + 78, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL3Three)), this.leftPos - 38 + 125, this.topPos - 26 + 78, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL3Four)), this.leftPos - 38 + 150, this.topPos - 26 + 78, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL3Five)), this.leftPos - 38 + 175, this.topPos - 26 + 78, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL4One)), this.leftPos - 38 + 75, this.topPos - 26 + 53, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL4Two)), this.leftPos - 38 + 100, this.topPos - 26 + 53, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL4Three)), this.leftPos - 38 + 125, this.topPos - 26 + 53, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL4Four)), this.leftPos - 38 + 150, this.topPos - 26 + 53, 0.0f, 0.0f, 23, 23, 23, 23);
        guiGraphics.blit(ResourceLocation.parse((String)this.assistersRender(this.previewL4Five)), this.leftPos - 38 + 175, this.topPos - 26 + 53, 0.0f, 0.0f, 23, 23, 23, 23);
        String keyRight = WeaversParadiseKeyMappings.MINIGAME_RIGHT_BUTTON.getTranslatedKeyMessage().getString();
        float keyRightScale = keyRight.length() > 5 ? 5.0f / (float)keyRight.length() : 1.0f;
        float rightStat = (float)this.rightColoredTime / 20.0f;
        int rightColor = 0xFF000000 | Mth.lerpInt((float)rightStat, (int)maxRed, (int)minRed) << 16 | Mth.lerpInt((float)rightStat, (int)maxGreen, (int)minGreen) << 8 | Mth.lerpInt((float)rightStat, (int)maxBlue, (int)minBlue);
        poseStack.pushPose();
        poseStack.scale(keyRightScale, keyRightScale, keyRightScale);
        poseStack.translate((float)this.leftPos / keyRightScale, ((float)(this.topPos - 26 + 237) + 5.0f * (1.0f - keyRightScale)) / keyRightScale, 1.0f);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)keyRight), 0, 0, rightColor);
        poseStack.popPose();
        String keyUp = WeaversParadiseKeyMappings.MINIGAME_UP_BUTTON.getTranslatedKeyMessage().getString();
        float keyUpScale = keyUp.length() > 5 ? 5.0f / (float)keyUp.length() : 1.0f;
        float upStat = (float)this.upColoredTime / 20.0f;
        int upColor = 0xFF000000 | Mth.lerpInt((float)upStat, (int)maxRed, (int)minRed) << 16 | Mth.lerpInt((float)upStat, (int)maxGreen, (int)minGreen) << 8 | Mth.lerpInt((float)upStat, (int)maxBlue, (int)minBlue);
        poseStack.pushPose();
        poseStack.scale(keyUpScale, keyUpScale, keyUpScale);
        poseStack.translate((float)(this.leftPos + 50) / keyUpScale, ((float)(this.topPos - 26 + 237) + 5.0f * (1.0f - keyUpScale)) / keyUpScale, 1.0f);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)keyUp), 0, 0, upColor);
        poseStack.popPose();
        String keyLeft = WeaversParadiseKeyMappings.MINIGAME_LEFT_BUTTON.getTranslatedKeyMessage().getString();
        float keyLeftScale = keyLeft.length() > 5 ? 5.0f / (float)keyLeft.length() : 1.0f;
        float leftStat = (float)this.leftColoredTime / 20.0f;
        int leftColor = 0xFF000000 | Mth.lerpInt((float)leftStat, (int)maxRed, (int)minRed) << 16 | Mth.lerpInt((float)leftStat, (int)maxGreen, (int)minGreen) << 8 | Mth.lerpInt((float)leftStat, (int)maxBlue, (int)minBlue);
        poseStack.pushPose();
        poseStack.scale(keyLeftScale, keyLeftScale, keyLeftScale);
        poseStack.translate((float)(this.leftPos + 100) / keyLeftScale, ((float)(this.topPos - 26 + 237) + 5.0f * (1.0f - keyLeftScale)) / keyLeftScale, 1.0f);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)keyLeft), 0, 0, leftColor);
        poseStack.popPose();
        String keyDown = WeaversParadiseKeyMappings.MINIGAME_DOWN_BUTTON.getTranslatedKeyMessage().getString();
        float keyDownScale = keyDown.length() > 5 ? 5.0f / (float)keyDown.length() : 1.0f;
        float downStat = (float)this.downColoredTime / 20.0f;
        int downColor = 0xFF000000 | Mth.lerpInt((float)downStat, (int)maxRed, (int)minRed) << 16 | Mth.lerpInt((float)downStat, (int)maxGreen, (int)minGreen) << 8 | Mth.lerpInt((float)downStat, (int)maxBlue, (int)minBlue);
        poseStack.pushPose();
        poseStack.scale(keyDownScale, keyDownScale, keyDownScale);
        poseStack.translate((float)(this.leftPos + 150) / keyDownScale, ((float)(this.topPos - 26 + 237) + 5.0f * (1.0f - keyDownScale)) / keyDownScale, 1.0f);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)keyDown), 0, 0, downColor);
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (gameStarted) {
            if (key == WeaversParadiseKeyMappings.MINIGAME_UP_BUTTON.getKey().getValue()) {
                this.upColoredTime = 20;
                if (this.inputOne.isBlank()) {
                    this.inputOne = "UP";
                } else if (this.inputTwo.isBlank()) {
                    this.inputTwo = "UP";
                } else if (this.inputThree.isBlank()) {
                    this.inputThree = "UP";
                } else if (this.inputFour.isBlank()) {
                    this.inputFour = "UP";
                } else if (this.inputFive.isBlank()) {
                    this.inputFive = "UP";
                }
            }
            if (key == WeaversParadiseKeyMappings.MINIGAME_RIGHT_BUTTON.getKey().getValue()) {
                this.rightColoredTime = 20;
                if (this.inputOne.isBlank()) {
                    this.inputOne = "RIGHT";
                } else if (this.inputTwo.isBlank()) {
                    this.inputTwo = "RIGHT";
                } else if (this.inputThree.isBlank()) {
                    this.inputThree = "RIGHT";
                } else if (this.inputFour.isBlank()) {
                    this.inputFour = "RIGHT";
                } else if (this.inputFive.isBlank()) {
                    this.inputFive = "RIGHT";
                }
            }
            if (key == WeaversParadiseKeyMappings.MINIGAME_DOWN_BUTTON.getKey().getValue()) {
                this.downColoredTime = 20;
                if (this.inputOne.isBlank()) {
                    this.inputOne = "DOWN";
                } else if (this.inputTwo.isBlank()) {
                    this.inputTwo = "DOWN";
                } else if (this.inputThree.isBlank()) {
                    this.inputThree = "DOWN";
                } else if (this.inputFour.isBlank()) {
                    this.inputFour = "DOWN";
                } else if (this.inputFive.isBlank()) {
                    this.inputFive = "DOWN";
                }
            }
            if (key == WeaversParadiseKeyMappings.MINIGAME_LEFT_BUTTON.getKey().getValue()) {
                this.leftColoredTime = 20;
                if (this.inputOne.isBlank()) {
                    this.inputOne = "LEFT";
                } else if (this.inputTwo.isBlank()) {
                    this.inputTwo = "LEFT";
                } else if (this.inputThree.isBlank()) {
                    this.inputThree = "LEFT";
                } else if (this.inputFour.isBlank()) {
                    this.inputFour = "LEFT";
                } else if (this.inputFive.isBlank()) {
                    this.inputFive = "LEFT";
                }
            }
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public boolean hasCraftItemsInSlot() {
        Slot slot = (Slot)((ClothcraftingMenu)this.menu).slots.get(0);
        if (slot != null) {
            if (slot.getItem().is((Item)WeaversParadiseItems.SILK_SPOOL.get()) && slot.getItem().getCount() > 5) {
                return true;
            }
            if (slot.getItem().is((Item)WeaversParadiseItems.WOOL_SPOOL.get()) && slot.getItem().getCount() > 5) {
                return true;
            }
            if (slot.getItem().is((Item)WeaversParadiseItems.COTTON_SPOOL.get()) && slot.getItem().getCount() > 5) {
                return true;
            }
        }
        return false;
    }

    public String getClothType() {
        Slot slot = (Slot)((ClothcraftingMenu)this.menu).slots.get(0);
        ItemStack stack = slot.getItem();
        Item item = stack.getItem();
        if (item instanceof SilkSpool) {
            SilkSpool silkSpool = (SilkSpool)item;
            return "SILK";
        }
        item = stack.getItem();
        if (item instanceof WoolSpool) {
            WoolSpool woolSpool = (WoolSpool)item;
            return "WOOL";
        }
        item = stack.getItem();
        if (item instanceof CottonSpool) {
            CottonSpool cottonSpool = (CottonSpool)item;
            return "COTTON";
        }
        return "";
    }

    public void init() {
        super.init();
        this.startMinigame = new ImageButton(this, this.leftPos + 3, this.topPos + 96, 72, 25, new WidgetSprites(ResourceLocation.parse((String)"weaversparadise:textures/screens/clothcrafting_button.png"), ResourceLocation.parse((String)"weaversparadise:textures/screens/clothcrafting_button.png")), e -> {
            if (this.hasCraftItemsInSlot()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ClothcraftingNetworkMultiMessage(1, this.x, this.y, this.z, 1800, 0, true, items, this.getClothType()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToServer((CustomPacketPayload)new ClothcraftingNetworkMultiMessage(5, this.x, this.y, this.z, gameTime, gameScore, gameStarted, items, clothType), (CustomPacketPayload[])new CustomPacketPayload[0]);
                guistate.remove("startMinigame");
                guistate.remove("claimItems");
                this.removeWidget((GuiEventListener)this.startMinigame);
                this.removeWidget((GuiEventListener)this.claimItems);
            }
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("startMinigame", this.startMinigame);
        this.addRenderableWidget((GuiEventListener)this.startMinigame);
        this.claimItems = new ImageButton(this, this.leftPos + 99, this.topPos + 96, 72, 25, new WidgetSprites(ResourceLocation.parse((String)"weaversparadise:textures/screens/clothcrafting_button.png"), ResourceLocation.parse((String)"weaversparadise:textures/screens/clothcrafting_button.png")), e -> PacketDistributor.sendToServer((CustomPacketPayload)new ClothcraftingNetworkMultiMessage(3, this.x, this.y, this.z, gameTime, gameScore, gameStarted, items, clothType), (CustomPacketPayload[])new CustomPacketPayload[0])){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("claimItems", this.claimItems);
        this.addRenderableWidget((GuiEventListener)this.claimItems);
        RandomSource random = RandomSource.create();
        this.previewL1One = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL1Two = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL1Three = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL1Four = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL1Five = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL2One = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL2Two = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL2Three = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL2Four = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL2Five = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL3One = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL3Two = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL3Three = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL3Four = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL3Five = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL4One = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL4Two = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL4Three = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL4Four = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.previewL4Five = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.pretypeOne = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.pretypeTwo = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.pretypeThree = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.pretypeFour = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
        this.pretypeFive = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
    }

    private String randomTextHelper(int num) {
        switch (num) {
            case 1: {
                return "UP";
            }
            case 2: {
                return "LEFT";
            }
            case 3: {
                return "DOWN";
            }
            case 4: {
                return "RIGHT";
            }
        }
        return "";
    }

    public void containerTick() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ClothcraftingNetworkMultiMessage(0, this.x, this.y, this.z, 0, 0, false, new ArrayList<ItemStack>(), clothType), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (this.upColoredTime > 0) {
            --this.upColoredTime;
        }
        if (this.rightColoredTime > 0) {
            --this.rightColoredTime;
        }
        if (this.downColoredTime > 0) {
            --this.downColoredTime;
        }
        if (this.leftColoredTime > 0) {
            --this.leftColoredTime;
        }
        if (this.pretypeOne != this.inputOne && !this.inputOne.isBlank()) {
            this.inputOne = "";
            this.inputTwo = "";
            this.inputThree = "";
            this.inputFour = "";
            this.inputFive = "";
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE, (float)0.5f));
        }
        if (this.pretypeTwo != this.inputTwo && !this.inputTwo.isBlank()) {
            this.inputOne = "";
            this.inputTwo = "";
            this.inputThree = "";
            this.inputFour = "";
            this.inputFive = "";
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE, (float)0.5f));
        }
        if (this.pretypeThree != this.inputThree && !this.inputThree.isBlank()) {
            this.inputOne = "";
            this.inputTwo = "";
            this.inputThree = "";
            this.inputFour = "";
            this.inputFive = "";
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE, (float)0.5f));
        }
        if (this.pretypeFour != this.inputFour && !this.inputFour.isBlank()) {
            this.inputOne = "";
            this.inputTwo = "";
            this.inputThree = "";
            this.inputFour = "";
            this.inputFive = "";
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE, (float)0.5f));
        }
        if (this.pretypeFive != this.inputFive && !this.inputFive.isBlank()) {
            this.inputOne = "";
            this.inputTwo = "";
            this.inputThree = "";
            this.inputFour = "";
            this.inputFive = "";
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE, (float)0.5f));
        }
        if (this.inputOne == this.pretypeOne && this.inputTwo == this.pretypeTwo && this.inputThree == this.pretypeThree && this.inputFour == this.pretypeFour && this.inputFive == this.pretypeFive) {
            RandomSource random = RandomSource.create();
            this.pretypeOne = this.previewL1One;
            this.pretypeTwo = this.previewL1Two;
            this.pretypeThree = this.previewL1Three;
            this.pretypeFour = this.previewL1Four;
            this.pretypeFive = this.previewL1Five;
            this.previewL1One = this.previewL2One;
            this.previewL1Two = this.previewL2Two;
            this.previewL1Three = this.previewL2Three;
            this.previewL1Four = this.previewL2Four;
            this.previewL1Five = this.previewL2Five;
            this.previewL2One = this.previewL3One;
            this.previewL2Two = this.previewL3Two;
            this.previewL2Three = this.previewL3Three;
            this.previewL2Four = this.previewL3Four;
            this.previewL2Five = this.previewL3Five;
            this.previewL3One = this.previewL4One;
            this.previewL3Two = this.previewL4Two;
            this.previewL3Three = this.previewL4Three;
            this.previewL3Four = this.previewL4Four;
            this.previewL3Five = this.previewL4Five;
            this.previewL4One = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
            this.previewL4Two = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
            this.previewL4Three = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
            this.previewL4Four = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
            this.previewL4Five = this.randomTextHelper(random.nextIntBetweenInclusive(1, 4));
            this.inputOne = "";
            this.inputTwo = "";
            this.inputThree = "";
            this.inputFour = "";
            this.inputFive = "";
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_CHIME, (float)2.0f));
            PacketDistributor.sendToServer((CustomPacketPayload)new ClothcraftingNetworkMultiMessage(1, this.x, this.y, this.z, gameTime, gameScore + 1, gameStarted, items, clothType), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!gameStarted && guistate.containsKey("startMinigame")) {
            guistate.put("startMinigame", this.startMinigame);
            this.addRenderableWidget((GuiEventListener)this.startMinigame);
        }
        if (!gameStarted && guistate.containsKey("claimItems")) {
            guistate.put("claimItems", this.claimItems);
            this.addRenderableWidget((GuiEventListener)this.claimItems);
        }
    }
}

