/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import xox.labvorty.weaversparadise.data.StringNetworkMessage;
import xox.labvorty.weaversparadise.gui.menu.StringMenu;

@OnlyIn(value=Dist.CLIENT)
public class StringScreen
extends AbstractContainerScreen<StringMenu> {
    private static final HashMap<String, Object> guistate = StringMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private static int progress = 0;

    public StringScreen(StringMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 200;
    }

    public static void updateProgress(int prog) {
        progress = prog;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float percentage = (float)(progress == 0 ? 1 : progress) / 100.0f;
        float realPercentage = 1.0f - percentage;
        guiGraphics.blit(ResourceLocation.parse((String)"weaversparadise:textures/screens/string_ui.png"), this.leftPos + -8, this.topPos + -16, 0.0f, 0.0f, 240, 216, 240, 216);
        guiGraphics.blit(ResourceLocation.parse((String)"weaversparadise:textures/screens/arrow_full.png"), this.leftPos + -8 + 152, this.topPos + -16 + 88, 0.0f, 0.0f, 31, 20, 31, 20);
        guiGraphics.blit(ResourceLocation.parse((String)"weaversparadise:textures/screens/arrow_empty.png"), this.leftPos + -8 + 152, this.topPos + -16 + 88, 0.0f, 0.0f, (int)(31.0f * realPercentage), 20, 31, 20);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
    }

    protected void containerTick() {
        PacketDistributor.sendToServer((CustomPacketPayload)new StringNetworkMessage(0, this.x, this.y, this.z, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

