/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.items;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class LeatherGloves
extends Item
implements ICurioItem {
    public LeatherGloves() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON).durability(64));
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 15;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.VANISHING_CURSE) || enchantment.is(Enchantments.MENDING);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)book).keySet().stream().anyMatch(holder -> holder.is(Enchantments.MENDING) || holder.is(Enchantments.UNBREAKING) || holder.is(Enchantments.VANISHING_CURSE));
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Items.LEATHER);
    }

    public boolean shouldReceiveDamage(ItemStack stack, RandomSource randomSource) {
        if (stack.isEnchanted()) {
            int level = 0;
            ItemEnchantments itemEnchantments = stack.getTagEnchantments();
            for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                Holder enchantmentHolder = (Holder)entry.getKey();
                if (!enchantmentHolder.is(Enchantments.UNBREAKING)) continue;
                level = stack.getEnchantmentLevel(enchantmentHolder);
            }
            return randomSource.nextIntBetweenInclusive(0, level) == 0;
        }
        return true;
    }
}

