/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.component.CustomData;
import xox.labvorty.weaversparadise.compat.emi.EmiCompat;

public class ClothcraftingEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;

    public ClothcraftingEmiRecipe(ResourceLocation id, List<EmiIngredient> inputs, List<EmiStack> outputs) {
        this.id = id;
        this.input = inputs;
        this.output = outputs;
    }

    public EmiRecipeCategory getCategory() {
        return EmiCompat.CLOTHCRAFTING_RECIPE_CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 192;
    }

    public int getDisplayHeight() {
        return 118;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"textures/recipes/clothcrafting_recipe_support.png"), 0, 0, 192, 118, 0, 0, 192, 118, 192, 118);
        widgets.addSlot(this.input.get(0), 46, 0).drawBack(false);
        CompoundTag tag = ((CustomData)this.output.get(0).getItemStack().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int score = Mth.clamp((int)(tag.getInt("quality") * 4), (int)0, (int)40);
        int maxscore = score + 3;
        widgets.addText((Component)Component.literal((String)(Component.translatable((String)"weaversparadise.clothcrafting.score").getString() + " " + score + "-" + String.valueOf(maxscore > 40 ? "40+" : Integer.valueOf(maxscore)))), 47, 54, 0, false);
        widgets.addSlot((EmiIngredient)this.output.get(0), 146, 101).recipeContext((EmiRecipe)this);
    }
}

