/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import xox.labvorty.weaversparadise.compat.emi.ClothcraftingEmiRecipe;
import xox.labvorty.weaversparadise.compat.emi.DyemakingEmiRecipe;
import xox.labvorty.weaversparadise.compat.emi.SpinningJennyEmiRecipe;
import xox.labvorty.weaversparadise.gui.screen.StringScreen;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;

@EmiEntrypoint
public class EmiCompat
implements EmiPlugin {
    public static final ResourceLocation CLOTHCRAFTING_SPRITESHEET = ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"textures/gui/emi_simplified_textures.png");
    public static final EmiStack CLOTHCRAFTING_WORKSTATION = EmiStack.of(WeaversParadiseItems.CLOTHCRAFTING_STATION);
    public static final EmiRecipeCategory CLOTHCRAFTING_RECIPE_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"clothcrafting"), (EmiRenderable)CLOTHCRAFTING_WORKSTATION, (EmiRenderable)new EmiTexture(CLOTHCRAFTING_SPRITESHEET, 0, 0, 16, 16));
    public static final ResourceLocation SPINNINGJENNY_SPRITESHEET = ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"textures/gui/emi_simplified_textures.png");
    public static final EmiStack SPINNINGJENNY_WORKSTATION = EmiStack.of(WeaversParadiseItems.SPINNING_JENNY);
    public static final EmiRecipeCategory SPINNINGJENNY_RECIPE_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"spinning_jenny"), (EmiRenderable)SPINNINGJENNY_WORKSTATION, (EmiRenderable)new EmiTexture(SPINNINGJENNY_SPRITESHEET, 0, 0, 16, 16));
    public static final ResourceLocation DYEMAKING_SPRITESHEET = ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"textures/gui/emi_simplified_textures.png");
    public static final EmiStack DYEMAKING_WORKSTATION = EmiStack.of(WeaversParadiseItems.DYEMAKING_BLOCK);
    public static final EmiRecipeCategory DYEMAKING_RECIPE_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"dyemaking"), (EmiRenderable)DYEMAKING_WORKSTATION, (EmiRenderable)new EmiTexture(DYEMAKING_SPRITESHEET, 0, 0, 16, 16));

    public void register(EmiRegistry registry) {
        registry.addExclusionArea(StringScreen.class, (screen, consumer) -> {
            int sx = screen.getGuiLeft() + 184 - 8;
            int sy = screen.getGuiTop() + 39 - 16;
            consumer.accept(new Bounds(sx, sy, 56, 105));
        });
        registry.addCategory(CLOTHCRAFTING_RECIPE_CATEGORY);
        registry.addCategory(SPINNINGJENNY_RECIPE_CATEGORY);
        registry.addCategory(DYEMAKING_RECIPE_CATEGORY);
        registry.addWorkstation(CLOTHCRAFTING_RECIPE_CATEGORY, (EmiIngredient)CLOTHCRAFTING_WORKSTATION);
        registry.addWorkstation(SPINNINGJENNY_RECIPE_CATEGORY, (EmiIngredient)SPINNINGJENNY_WORKSTATION);
        registry.addWorkstation(DYEMAKING_RECIPE_CATEGORY, (EmiIngredient)DYEMAKING_WORKSTATION);
        int i = 0;
        while (i <= 10) {
            int quality = i++;
            ArrayList<EmiStack> emiStacks1 = new ArrayList<EmiStack>();
            ItemStack stack1 = new ItemStack((ItemLike)WeaversParadiseItems.COTTON_CLOTH.get());
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack1, tag -> tag.putInt("quality", quality));
            emiStacks1.add(EmiStack.of((ItemStack)stack1, (long)1L));
            ArrayList<EmiStack> emiStacks2 = new ArrayList<EmiStack>();
            ItemStack stack2 = new ItemStack((ItemLike)WeaversParadiseItems.SILK_CLOTH.get());
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack2, tag -> tag.putInt("quality", quality));
            emiStacks2.add(EmiStack.of((ItemStack)stack2, (long)1L));
            ArrayList<EmiStack> emiStacks3 = new ArrayList<EmiStack>();
            ItemStack stack3 = new ItemStack((ItemLike)WeaversParadiseItems.WOOL_CLOTH.get());
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack3, tag -> tag.putInt("quality", quality));
            emiStacks3.add(EmiStack.of((ItemStack)stack3, (long)1L));
            registry.addDeferredRecipes(deferred -> deferred.accept(new ClothcraftingEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)("/clothcrafting_cotton_cloth_" + quality)), List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)WeaversParadiseItems.COTTON_SPOOL.get()})).setAmount(6L)), emiStacks1)));
            registry.addDeferredRecipes(deferred -> deferred.accept(new ClothcraftingEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)("/clothcrafting_silk_cloth_" + quality)), List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)WeaversParadiseItems.SILK_SPOOL.get()})).setAmount(6L)), emiStacks2)));
            registry.addDeferredRecipes(deferred -> deferred.accept(new ClothcraftingEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)("/clothcrafting_wool_cloth_" + quality)), List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)WeaversParadiseItems.WOOL_SPOOL.get()})).setAmount(6L)), emiStacks3)));
        }
        registry.addDeferredRecipes(deferred -> deferred.accept(new SpinningJennyEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"/spinning_jenny_cotton_spool"), List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)WeaversParadiseItems.EMPTY_SPOOL.get()})).setAmount(1L), EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)WeaversParadiseItems.RAW_COTTON.get()})).setAmount(4L)), List.of(EmiStack.of((ItemStack)new ItemStack((ItemLike)WeaversParadiseItems.COTTON_SPOOL.get()), (long)1L)))));
        registry.addDeferredRecipes(deferred -> deferred.accept(new SpinningJennyEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"/spinning_jenny_silk_spool"), List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)WeaversParadiseItems.EMPTY_SPOOL.get()})).setAmount(1L), EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING})).setAmount(5L)), List.of(EmiStack.of((ItemStack)new ItemStack((ItemLike)WeaversParadiseItems.SILK_SPOOL.get()), (long)1L)))));
        registry.addDeferredRecipes(deferred -> deferred.accept(new SpinningJennyEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"/spinning_jenny_wool_spool"), List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)WeaversParadiseItems.EMPTY_SPOOL.get()})).setAmount(1L), EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_WOOL})).setAmount(1L)), List.of(EmiStack.of((ItemStack)new ItemStack((ItemLike)WeaversParadiseItems.COTTON_SPOOL.get()), (long)1L)))));
        List<String> dyeTypes = List.of("agender", "aroace", "aromantic", "asexual", "bisexual", "demiboy", "demigender", "demigirl", "gay", "genderfluid", "genderqueer", "intersex", "lesbian", "nonbinary", "pansexual", "pride", "trans", "sculk", "glowstone", "rainbow", "biome", "ender", "speed", "height_bedrock", "height_sea", "redstone", "lamp");
        ArrayList<ItemStack> dyeCores = new ArrayList<ItemStack>();
        ArrayList<ItemStack> bottledDyes = new ArrayList<ItemStack>();
        ItemStack baseDyeCore = new ItemStack((ItemLike)WeaversParadiseItems.DYE_CORE.get());
        ItemStack baseBottledDye = new ItemStack((ItemLike)WeaversParadiseItems.BOTTLED_DYE.get());
        for (String entry : dyeTypes) {
            ItemStack dyeCore = baseDyeCore.copy();
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)dyeCore, tag -> tag.putString("dyeType", entry));
            dyeCores.add(dyeCore);
            ItemStack bottledDye = baseBottledDye.copy();
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)bottledDye, tag -> tag.putString("dyeType", entry));
            bottledDyes.add(bottledDye);
        }
        int i2 = 0;
        while (i2 < dyeCores.size()) {
            int j = i2++;
            registry.addDeferredRecipes(deferred -> deferred.accept(new DyemakingEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)("/dyemaking_" + (String)dyeTypes.get(j))), List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{(ItemStack)dyeCores.get(j)})), EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.POTION})), EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE})), EmiIngredient.of((Ingredient)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"weaversparadise:vanilla_dyes")))), EmiIngredient.of((Ingredient)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"weaversparadise:vanilla_dyes")))), EmiIngredient.of((Ingredient)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"weaversparadise:vanilla_dyes")))), EmiIngredient.of((Ingredient)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"weaversparadise:vanilla_dyes")))), EmiIngredient.of((Ingredient)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"weaversparadise:vanilla_dyes")))), EmiIngredient.of((Ingredient)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"weaversparadise:vanilla_dyes")))), EmiIngredient.of((Ingredient)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"weaversparadise:vanilla_dyes")))), EmiIngredient.of((Ingredient)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"weaversparadise:vanilla_dyes")))), EmiIngredient.of((Ingredient)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"weaversparadise:vanilla_dyes"))))), List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{(ItemStack)bottledDyes.get(j)}))))));
        }
    }
}

