/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.items;

import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import xox.labvorty.weaversparadise.data.WeaversParadiseDyeIconHandler;
import xox.labvorty.weaversparadise.tooltips.BottledDyeTooltipComponent;

public class BottledDyeItem
extends Item {
    public BottledDyeItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON).component(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag(){
            {
                this.putString("dyeType", "default");
                this.putInt("colorRedOne", 255);
                this.putInt("colorGreenOne", 255);
                this.putInt("colorBlueOne", 255);
                this.putInt("colorRedTwo", 255);
                this.putInt("colorGreenTwo", 255);
                this.putInt("colorBlueTwo", 255);
                this.putInt("amount", 10);
                this.putInt("lightValue", 15);
            }
        })));
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return 0xFFFFFF;
    }

    public int getBarWidth(ItemStack stack) {
        int amount = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("amount");
        return (int)((float)amount / 10.0f * 13.0f);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        CompoundTag data = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return Optional.of(new BottledDyeTooltipComponent(WeaversParadiseDyeIconHandler.getOrDefault(data.getString("dyeType")).getTexture(), data.getString("dyeType"), data.getString("dyeType"), data.getInt("lightValue"), this.getItemMainColor(stack), this.getItemSecondaryColor(stack)));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        CompoundTag compoundTag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int color = Mth.lerpInt((float)((float)compoundTag.getInt("lightValue") / 15.0f), (int)100, (int)255);
        if (compoundTag.getString("dyeType").equals("redstone")) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
                tag.putInt("colorRedOne", color);
                tag.putInt("colorGreenOne", 0);
                tag.putInt("colorBlueOne", 0);
            });
        }
        if (compoundTag.getInt("amount") < 1 && entity instanceof Player) {
            Player player = (Player)entity;
            player.getInventory().setItem(slotId, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
    }

    public int getItemMainColor(ItemStack stack) {
        int color = 0;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int red = tag.getInt("colorRedOne");
        int green = tag.getInt("colorGreenOne");
        int blue = tag.getInt("colorBlueOne");
        color = 0xFF000000 | red << 16 | green << 8 | blue;
        return color;
    }

    public int getItemSecondaryColor(ItemStack stack) {
        int color = 0;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int red = tag.getInt("colorRedTwo");
        int green = tag.getInt("colorGreenTwo");
        int blue = tag.getInt("colorBlueTwo");
        color = 0xFF000000 | red << 16 | green << 8 | blue;
        return color;
    }

    public int getItemLightValue(ItemStack stack) {
        int lightValue = 0;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        lightValue = tag.getInt("lightValue");
        return lightValue;
    }
}

