/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.items;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import xox.labvorty.weaversparadise.gui.menu.StringMenu;
import xox.labvorty.weaversparadise.init.WeaversParadiseModAttributes;
import xox.labvorty.weaversparadise.tooltips.ImageTooltipComponent;

public class TestItem
extends Item
implements ICurioItem {
    public TestItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON).attributes(new ItemAttributeModifiers(List.of(new ItemAttributeModifiers.Entry(WeaversParadiseModAttributes.LIFESTEAL, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"lifesteal"), 0.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)), true)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            final BlockPos bPos = BlockPos.containing((double)player.getX(), (double)player.getY(), (double)player.getZ());
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"StringScreen");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new StringMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(bPos));
                }
            }, bPos);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        return Optional.of(new ImageTooltipComponent(list, ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"textures/tooltips/star_full.png"), "This is a test text", "default", 15, -1, -1, ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"textures/tooltips/star_full.png"), "This is a test text", "default", 15, -1, -1, ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"textures/tooltips/star_full.png"), "This is a test text", "default", 15, -1, -1, ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"textures/tooltips/star_full.png"), "This is a test text", "default", 15, -1, -1));
    }
}

