/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.spigot;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import ru.kawaii.easycameramod.spigot.config.DisplayMode;
import ru.kawaii.easycameramod.spigot.config.PlayerDisplaySettings;
import ru.kawaii.easycameramod.spigot.lib.bstats.Metrics;
import ru.kawaii.easycameramod.spigot.managers.PlayerDisplaySettingsManager;

public class EasyCameraModSpigot
extends JavaPlugin
implements PluginMessageListener,
Listener {
    private static final String C2S_WEBCAM_CHANNEL = "easycameramod:c2s_webcam_data";
    private static final String S2C_WEBCAM_CHANNEL = "easycameramod:s2c_webcam_data";
    private static final String S2C_REMOVE_CHANNEL = "easycameramod:s2c_remove_webcam";
    private static final String C2S_SETTINGS_CHANNEL = "easycameramod:c2s_update_display_settings";
    private static final String S2C_SETTINGS_CHANNEL = "easycameramod:s2c_display_settings";
    private static final long FRAME_INTERVAL_MS = 33L;
    private final PlayerDisplaySettingsManager settingsManager = new PlayerDisplaySettingsManager();
    private final Map<UUID, Long> lastPacketTimestamps = new ConcurrentHashMap<UUID, Long>();

    public void onEnable() {
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, C2S_WEBCAM_CHANNEL, (PluginMessageListener)this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, C2S_SETTINGS_CHANNEL, (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, S2C_WEBCAM_CHANNEL);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, S2C_REMOVE_CHANNEL);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, S2C_SETTINGS_CHANNEL);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        int pluginId = 26285;
        new Metrics(this, pluginId);
        this.getLogger().info("EasyCameraMod-Spigot has been enabled!");
    }

    public void onDisable() {
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        this.getLogger().info("EasyCameraMod-Spigot has been disabled!");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player newPlayer = event.getPlayer();
        UUID newPlayerUuid = newPlayer.getUniqueId();
        for (Map.Entry<UUID, PlayerDisplaySettings> entry : this.settingsManager.getAllSettings().entrySet()) {
            this.sendSettingsToPlayer(newPlayer, entry.getKey(), entry.getValue());
        }
        PlayerDisplaySettings defaultSettings = PlayerDisplaySettings.createDefault();
        this.settingsManager.updateSettings(newPlayerUuid, defaultSettings);
        this.broadcastSettings(newPlayerUuid, defaultSettings, null);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player quittingPlayer = event.getPlayer();
        this.settingsManager.removeSettings(quittingPlayer.getUniqueId());
        this.lastPacketTimestamps.remove(quittingPlayer.getUniqueId());
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeLong(quittingPlayer.getUniqueId().getMostSignificantBits());
        out.writeLong(quittingPlayer.getUniqueId().getLeastSignificantBits());
        byte[] message = out.toByteArray();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayer.sendPluginMessage((Plugin)this, S2C_REMOVE_CHANNEL, message);
        }
    }

    public void onPluginMessageReceived(String channel, Player sender, byte[] message) {
        if (C2S_WEBCAM_CHANNEL.equals(channel)) {
            this.handleWebcamData(sender, message);
        } else if (C2S_SETTINGS_CHANNEL.equals(channel)) {
            this.handleSettingsUpdate(sender, message);
        }
    }

    private void handleWebcamData(Player sender, byte[] message) {
        long lastTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastPacketTimestamps.getOrDefault(sender.getUniqueId(), 0L).longValue()) < 33L) {
            return;
        }
        this.lastPacketTimestamps.put(sender.getUniqueId(), currentTime);
        if (message.length == 0) {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeLong(sender.getUniqueId().getMostSignificantBits());
            out.writeLong(sender.getUniqueId().getLeastSignificantBits());
            byte[] removeMessage = out.toByteArray();
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (onlinePlayer.getUniqueId().equals(sender.getUniqueId())) continue;
                onlinePlayer.sendPluginMessage((Plugin)this, S2C_REMOVE_CHANNEL, removeMessage);
            }
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeLong(sender.getUniqueId().getMostSignificantBits());
        out.writeLong(sender.getUniqueId().getLeastSignificantBits());
        this.writeVarInt(out, message.length);
        out.write(message);
        byte[] s2cMessage = out.toByteArray();
        for (Player recipient : Bukkit.getOnlinePlayers()) {
            if (recipient.getUniqueId().equals(sender.getUniqueId())) continue;
            recipient.sendPluginMessage((Plugin)this, S2C_WEBCAM_CHANNEL, s2cMessage);
        }
    }

    private void handleSettingsUpdate(Player sender, byte[] rawMessage) {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])rawMessage);
        try {
            DisplayMode displayMode = DisplayMode.values()[this.readVarInt(in)];
            float cropBoxX = in.readFloat();
            float cropBoxY = in.readFloat();
            float cropBoxSize = in.readFloat();
            PlayerDisplaySettings newSettings = new PlayerDisplaySettings(displayMode, cropBoxX, cropBoxY, cropBoxSize);
            this.settingsManager.updateSettings(sender.getUniqueId(), newSettings);
            this.broadcastSettings(sender.getUniqueId(), newSettings, sender);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to parse display settings packet from " + sender.getName() + ": " + e.getMessage());
        }
    }

    private void broadcastSettings(UUID fromPlayer, PlayerDisplaySettings settings, Player excludePlayer) {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (excludePlayer != null && onlinePlayer.getUniqueId().equals(excludePlayer.getUniqueId())) continue;
            this.sendSettingsToPlayer(onlinePlayer, fromPlayer, settings);
        }
    }

    private void sendSettingsToPlayer(Player recipient, UUID subject, PlayerDisplaySettings settings) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeLong(subject.getMostSignificantBits());
        out.writeLong(subject.getLeastSignificantBits());
        this.writeVarInt(out, settings.displayMode().ordinal());
        out.writeFloat(settings.cropBoxX());
        out.writeFloat(settings.cropBoxY());
        out.writeFloat(settings.cropBoxSize());
        recipient.sendPluginMessage((Plugin)this, S2C_SETTINGS_CHANNEL, out.toByteArray());
    }

    private int readVarInt(ByteArrayDataInput in) {
        byte b0;
        int i = 0;
        int j = 0;
        do {
            b0 = in.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt is too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    private void writeVarInt(ByteArrayDataOutput out, int value) {
        int localValue = value;
        while ((localValue & 0xFFFFFF80) != 0) {
            out.writeByte(localValue & 0x7F | 0x80);
            localValue >>>= 7;
        }
        out.writeByte(localValue);
    }
}

