/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.spigot.lib.bstats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Metrics {
    public static final int B_STATS_VERSION = 2;
    private static final String URL = "https://bStats.org/submitData/bukkit";
    private final List<CustomChart> charts = new ArrayList<CustomChart>();
    private final Plugin plugin;

    public Metrics(JavaPlugin plugin, final int serviceId) {
        this.plugin = plugin;
        File bStatsFolder = new File(plugin.getDataFolder().getParentFile(), "bStats");
        File configFile = new File(bStatsFolder, "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        if (!config.isSet("serverUuid")) {
            config.addDefault("enabled", (Object)true);
            config.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
            config.addDefault("logFailedRequests", (Object)false);
            config.addDefault("logSentData", (Object)false);
            config.addDefault("logResponseStatusText", (Object)false);
            config.options().setHeader(List.of("bStats (https://bStats.org) collects some basic information for plugin authors, like how", "many people use their plugin and their server versions. It's recommended to keep bStats", "enabled, but if you're not comfortable with this, you can turn this setting off. There", "is no performance penalty associated with having metrics enabled, and data sent to bStats", "is anonymous.")).copyDefaults(true);
            try {
                config.save(configFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!config.getBoolean("enabled", true)) {
            return;
        }
        final String serverUUID = config.getString("serverUuid");
        final boolean logErrors = config.getBoolean("logFailedRequests", false);
        final boolean logSentData = config.getBoolean("logSentData", false);
        final boolean logResponseStatusText = config.getBoolean("logResponseStatusText", false);
        final String pluginName = plugin.getDescription().getName();
        final String pluginVersion = plugin.getDescription().getVersion();
        new Timer(true).scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Metrics.this.submitData(serviceId, serverUUID, logErrors, logSentData, logResponseStatusText, pluginName, pluginVersion);
            }
        }, 300000L, 1800000L);
    }

    public void addCustomChart(CustomChart chart) {
        this.charts.add(chart);
    }

    private void submitData(int serviceId, String serverUUID, boolean logErrors, boolean logSentData, boolean logResponseStatusText, String pluginName, String pluginVersion) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, () -> {
            block17: {
                try {
                    HttpsURLConnection connection = (HttpsURLConnection)new URL(URL).openConnection();
                    byte[] compressedData = Metrics.compress(this.getPluginData(pluginName, pluginVersion).toString());
                    connection.setRequestMethod("POST");
                    connection.addRequestProperty("Accept", "application/json");
                    connection.addRequestProperty("Connection", "close");
                    connection.addRequestProperty("Content-Encoding", "gzip");
                    connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setRequestProperty("User-Agent", "bStats-Metrics/2");
                    connection.addRequestProperty("X-Service-Id", String.valueOf(serviceId));
                    connection.addRequestProperty("X-Server-Id", serverUUID);
                    connection.setDoOutput(true);
                    try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
                        outputStream.write(compressedData);
                    }
                    StringBuilder builder = new StringBuilder();
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                        String line;
                        while ((line = bufferedReader.readLine()) != null) {
                            builder.append(line);
                        }
                    }
                    if (logSentData) {
                        this.plugin.getLogger().info("Sent data to bStats: " + String.valueOf(builder));
                    }
                    if (logResponseStatusText) {
                        this.plugin.getLogger().info("Sent data to bStats and received response: " + String.valueOf(builder));
                    }
                }
                catch (Exception e) {
                    if (!logErrors) break block17;
                    this.plugin.getLogger().log(Level.WARNING, "Could not submit stats of " + this.plugin.getName(), e);
                }
            }
        });
    }

    private JsonObject getPluginData(String pluginName, String pluginVersion) {
        JsonObject data = new JsonObject();
        data.addProperty("pluginName", pluginName);
        data.addProperty("pluginVersion", pluginVersion);
        data.add("customCharts", (JsonElement)this.getCustomChartsData());
        return data;
    }

    private JsonObject getCustomChartsData() {
        JsonObject data = new JsonObject();
        for (CustomChart customChart : this.charts) {
            if (customChart.getRequestJsonObject(this.plugin.getLogger()) == null) continue;
            data.add(customChart.getChartId(), (JsonElement)customChart.getRequestJsonObject(this.plugin.getLogger()));
        }
        return data;
    }

    private static byte[] compress(String str) throws IOException {
        if (str == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
            gzip.write(str.getBytes(StandardCharsets.UTF_8));
        }
        return outputStream.toByteArray();
    }

    static {
        if (System.getProperty("bstats.relocatecheck") == null || !System.getProperty("bstats.relocatecheck").equals("false")) {
            String defaultPackage = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115, 46, 98, 117, 107, 107, 105, 116});
            String examplePackage = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
            if (Metrics.class.getPackage().getName().equals(defaultPackage) || Metrics.class.getPackage().getName().equals(examplePackage)) {
                throw new IllegalStateException("bStats Metrics class has not been relocated correctly!");
            }
        }
    }

    public static abstract class CustomChart {
        private final String chartId;

        protected CustomChart(String chartId) {
            if (chartId == null) {
                throw new IllegalArgumentException("chartId must not be null");
            }
            this.chartId = chartId;
        }

        public String getChartId() {
            return this.chartId;
        }

        protected abstract JsonObject getRequestJsonObject(Logger var1);
    }

    public static class SimplePie
    extends CustomChart {
        private final Callable<String> callable;

        public SimplePie(String chartId, Callable<String> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JsonObject getRequestJsonObject(Logger logger) {
            JsonObject chart = new JsonObject();
            try {
                String value = this.callable.call();
                if (value == null || value.isEmpty()) {
                    return null;
                }
                chart.addProperty("value", value);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to get value for custom chart with id " + this.getChartId(), e);
                return null;
            }
            return chart;
        }
    }
}

