/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod;

import com.github.sarxos.webcam.WebcamException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.minecraft.class_1007;
import ru.kawaii.easycameramod.EasyCameraMod;
import ru.kawaii.easycameramod.WebcamManager;
import ru.kawaii.easycameramod.client.KeyBinds;
import ru.kawaii.easycameramod.client.MutedPlayersManager;
import ru.kawaii.easycameramod.client.PlayerDisplaySettingsManager;
import ru.kawaii.easycameramod.client.PlayerWebcamManager;
import ru.kawaii.easycameramod.client.renderer.HudRenderer;
import ru.kawaii.easycameramod.client.renderer.WebcamFeatureRenderer;
import ru.kawaii.easycameramod.config.Config;
import ru.kawaii.easycameramod.config.ConfigManager;
import ru.kawaii.easycameramod.networking.ClientPacketHandler;
import ru.kawaii.easycameramod.networking.NetworkConstants;

@Environment(value=EnvType.CLIENT)
public class EasyCameraModClient
implements ClientModInitializer {
    public void onInitializeClient() {
        NetworkConstants.register();
        ConfigManager.loadConfig();
        MutedPlayersManager.loadMutedPlayers();
        this.disableWebcamForSafety();
        KeyBinds.register();
        ClientPacketHandler.register();
        PlayerWebcamManager.getInstance().initialize();
        HudRenderer.init();
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if (entityRenderer instanceof class_1007) {
                class_1007 playerRenderer = (class_1007)entityRenderer;
                registrationHelper.register(new WebcamFeatureRenderer(playerRenderer));
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            PlayerWebcamManager.getInstance().clearAll();
            PlayerDisplaySettingsManager.getInstance().clearAll();
            WebcamManager.getInstance().stop();
            try {
                WebcamManager.getInstance().selectWebcam(null);
            }
            catch (WebcamException e) {
                EasyCameraMod.LOGGER.error("Failed to deselect webcam on disconnect", (Throwable)e);
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            PlayerWebcamManager.getInstance().clearAll();
            PlayerDisplaySettingsManager.getInstance().clearAll();
            this.disableWebcamForSafety();
        });
    }

    private void disableWebcamForSafety() {
        Config config = ConfigManager.getConfig();
        config.webcamEnabled = false;
        config.selectedWebcam = "";
        ConfigManager.saveConfig();
        WebcamManager.getInstance().stop();
    }
}

