/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class MutedPlayersManager {
    private static final Path MUTED_PLAYERS_PATH = FabricLoader.getInstance().getConfigDir().resolve("easycameramod_muted.txt");
    private static Set<UUID> mutedPlayers = new HashSet<UUID>();

    public static void loadMutedPlayers() {
        HashSet<UUID> set = new HashSet<UUID>();
        if (Files.exists(MUTED_PLAYERS_PATH, new LinkOption[0])) {
            try {
                for (String line : Files.readAllLines(MUTED_PLAYERS_PATH)) {
                    try {
                        set.add(UUID.fromString(line.trim()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        mutedPlayers = set;
    }

    public static void saveMutedPlayers() {
        try {
            Files.createDirectories(MUTED_PLAYERS_PATH.getParent(), new FileAttribute[0]);
            Files.write(MUTED_PLAYERS_PATH, (Iterable<? extends CharSequence>)mutedPlayers.stream().map(UUID::toString).collect(Collectors.toList()), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isMuted(UUID uuid) {
        return mutedPlayers.contains(uuid);
    }

    public static void mute(UUID uuid) {
        mutedPlayers.add(uuid);
        MutedPlayersManager.saveMutedPlayers();
    }

    public static void unmute(UUID uuid) {
        mutedPlayers.remove(uuid);
        MutedPlayersManager.saveMutedPlayers();
    }

    public static Set<UUID> getMutedPlayers() {
        return mutedPlayers;
    }
}

