/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.client;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import ru.kawaii.easycameramod.config.PlayerDisplaySettings;

@Environment(value=EnvType.CLIENT)
public class PlayerDisplaySettingsManager {
    private static final PlayerDisplaySettingsManager INSTANCE = new PlayerDisplaySettingsManager();
    private final Map<UUID, PlayerDisplaySettings> settingsMap = new ConcurrentHashMap<UUID, PlayerDisplaySettings>();
    private static final PlayerDisplaySettings DEFAULT_SETTINGS = PlayerDisplaySettings.createDefault();

    private PlayerDisplaySettingsManager() {
    }

    public static PlayerDisplaySettingsManager getInstance() {
        return INSTANCE;
    }

    public void updateSettings(UUID playerUuid, PlayerDisplaySettings settings) {
        this.settingsMap.put(playerUuid, settings);
    }

    public PlayerDisplaySettings getSettings(UUID playerUuid) {
        return this.settingsMap.getOrDefault(playerUuid, DEFAULT_SETTINGS);
    }

    public void removeSettings(UUID playerUuid) {
        this.settingsMap.remove(playerUuid);
    }

    public void clearAll() {
        this.settingsMap.clear();
    }
}

