/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.client;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import ru.kawaii.easycameramod.EasyCameraMod;

@Environment(value=EnvType.CLIENT)
public class WebcamTextureManager {
    private final Map<UUID, class_1043> textures = new ConcurrentHashMap<UUID, class_1043>();
    private final Map<UUID, class_2960> identifiers = new ConcurrentHashMap<UUID, class_2960>();
    private final ExecutorService decodingExecutor = Executors.newCachedThreadPool();
    private final class_310 client = class_310.method_1551();

    public void updateTexture(UUID playerUuid, byte[] frameData) {
        if (frameData == null) {
            this.removePlayer(playerUuid);
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            try {
                BufferedImage bImage = ImageIO.read(new ByteArrayInputStream(frameData));
                if (bImage == null) {
                    throw new IOException("Failed to decode image.");
                }
                class_1011 image = new class_1011(bImage.getWidth(), bImage.getHeight(), false);
                for (int y = 0; y < bImage.getHeight(); ++y) {
                    for (int x = 0; x < bImage.getWidth(); ++x) {
                        int rgb = bImage.getRGB(x, y);
                        image.method_4305(x, y, rgb & 0xFF000000 | (rgb & 0xFF0000) >> 16 | rgb & 0xFF00 | (rgb & 0xFF) << 16);
                    }
                }
                return image;
            }
            catch (IOException e) {
                EasyCameraMod.LOGGER.error("Failed to read webcam frame for player {}", (Object)playerUuid, (Object)e);
                return null;
            }
        }, this.decodingExecutor).thenAcceptAsync(image -> {
            if (image == null) {
                this.removePlayer(playerUuid);
                return;
            }
            class_1043 texture = this.textures.get(playerUuid);
            if (texture != null && texture.method_4525() != null && texture.method_4525().method_4307() == image.method_4307() && texture.method_4525().method_4323() == image.method_4323()) {
                texture.method_4525().method_4317(image);
                image.close();
                texture.method_4524();
            } else {
                if (texture != null) {
                    this.client.method_1531().method_4615(this.identifiers.get(playerUuid));
                }
                texture = new class_1043(image);
                class_2960 textureId = this.client.method_1531().method_4617("easycameramod_webcam/" + String.valueOf(playerUuid), texture);
                this.textures.put(playerUuid, texture);
                this.identifiers.put(playerUuid, textureId);
            }
        }, (Executor)this.client);
    }

    public class_2960 getTexture(UUID playerUuid) {
        return this.identifiers.get(playerUuid);
    }

    public void removePlayer(UUID playerUuid) {
        class_2960 textureId = this.identifiers.remove(playerUuid);
        if (textureId != null) {
            this.client.execute(() -> this.client.method_1531().method_4615(textureId));
        }
        this.textures.remove(playerUuid);
    }

    public void clearAll() {
        this.identifiers.keySet().forEach(this::removePlayer);
    }
}

