/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.client.gui;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5498;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import ru.kawaii.easycameramod.WebcamManager;
import ru.kawaii.easycameramod.client.PlayerDisplaySettingsManager;
import ru.kawaii.easycameramod.config.Config;
import ru.kawaii.easycameramod.config.ConfigManager;
import ru.kawaii.easycameramod.config.PlayerDisplaySettings;
import ru.kawaii.easycameramod.networking.payload.C2SUpdateDisplaySettingsPayload;

@Environment(value=EnvType.CLIENT)
public class SettingsScreen
extends class_437 {
    private final class_437 parent;
    private class_5498 originalPerspective;
    private float originalYaw;
    private float originalPitch;
    private WebcamEntryList webcamEntryList;
    private class_5676<Boolean> visibleToggleButton;
    private class_5676<Config.CameraIndicator> cameraIndicatorButton;
    private class_357 cameraIndicatorScaleSlider;
    private class_5676<Config.DisplayMode> displayModeButton;
    private class_357 cropBoxXSlider;
    private class_357 cropBoxYSlider;
    private class_357 cropBoxSizeSlider;
    private class_357 cameraPositionXSlider;
    private class_357 cameraPositionYSlider;
    private class_357 cameraPositionZSlider;
    private class_357 cameraScaleSlider;
    private class_4185 doneButton;

    public SettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gui.easycameramod.settings.title"));
        this.parent = parent;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            if (!this.webcamEntryList.canSwitch) {
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.easycameramod.settings.opening_webcam"), this.field_22789 / 4 * 2, 50, -1);
            }
        } else {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.easycameramod.settings.server_only_error"), this.field_22789 / 2, this.field_22790 / 2, -39065);
        }
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.easycameramod.settings.select_webcam"), this.field_22789 / 8, 20, 0xFFFFFF);
    }

    protected void method_25426() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.originalPerspective = this.field_22787.field_1690.method_31044();
            this.originalYaw = this.field_22787.field_1724.method_36454();
            this.originalPitch = this.field_22787.field_1724.method_36455();
            this.field_22787.field_1690.method_31043(class_5498.field_26666);
            float snappedYaw = (float)Math.round(this.field_22787.field_1724.method_36454() / 90.0f) * 90.0f;
            this.field_22787.field_1724.method_36456(snappedYaw);
            this.field_22787.field_1724.method_36457(0.0f);
            this.field_22787.field_1724.method_5636(snappedYaw);
            this.field_22787.field_1724.method_5847(snappedYaw);
            this.initWebcamList();
            this.initVisibleToggle();
            this.initCameraIndicatorButton();
            this.initDisplayModeControls();
            this.updateCropBoxControlsVisibility();
            this.updateIndicatorControlsVisibility();
            this.initCameraPositionControls();
            this.initDoneButton();
        } else {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(this.parent);
                }
            }).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 40, 200, 20).method_46431());
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            if (this.field_22787.field_1724 != null && this.originalPerspective != null) {
                this.field_22787.field_1690.method_31043(this.originalPerspective);
                this.field_22787.field_1724.method_36456(this.originalYaw);
                this.field_22787.field_1724.method_36457(this.originalPitch);
                this.field_22787.field_1724.method_5636(this.originalYaw);
            }
            if (ConfigManager.getConfig().webcamEnabled) {
                WebcamManager.getInstance().start();
            } else {
                WebcamManager.getInstance().stop();
            }
            ConfigManager.saveConfig();
            this.field_22787.method_1507(this.parent);
        }
    }

    private void initDoneButton() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 30, 200, 20).method_46431());
    }

    private void initWebcamList() {
        int listWidth = this.field_22789 / 4;
        this.webcamEntryList = new WebcamEntryList(this.field_22787, listWidth, this.field_22790 - 80, 40, 20);
        this.webcamEntryList.onSelected(webcam -> {
            try {
                WebcamManager.getInstance().selectWebcam((Webcam)webcam);
            }
            catch (WebcamException e) {
                System.out.println(e.getMessage());
            }
            return null;
        });
        this.method_37063((class_364)this.webcamEntryList);
    }

    private void initVisibleToggle() {
        int buttonWidth = 180;
        int rightSideX = this.field_22789 - buttonWidth - 10;
        int startY = 50;
        this.visibleToggleButton = class_5676.method_32606(visible -> class_2561.method_43471((String)(visible != false ? "gui.on" : "gui.off"))).method_32624((Object[])new Boolean[]{true, false}).method_32619((Object)ConfigManager.getConfig().webcamEnabled).method_32617(rightSideX, startY, buttonWidth, 20, (class_2561)class_2561.method_43471((String)"gui.easycameramod.settings.webcam"), (button, value) -> {
            ConfigManager.getConfig().webcamEnabled = value;
            if (value.booleanValue()) {
                WebcamManager.getInstance().start();
            } else {
                WebcamManager.getInstance().stop();
            }
        });
        this.method_37063((class_364)this.visibleToggleButton);
    }

    private void initCameraIndicatorButton() {
        int buttonWidth = 180;
        int rightSideX = this.field_22789 - buttonWidth - 10;
        int y = 74;
        this.cameraIndicatorButton = class_5676.method_32606(indicator -> class_2561.method_43471((String)("gui.easycameramod.settings.camera_indicator." + indicator.name().toLowerCase()))).method_32624((Object[])Config.CameraIndicator.values()).method_32619((Object)ConfigManager.getConfig().cameraIndicator).method_32617(rightSideX, y, buttonWidth, 20, (class_2561)class_2561.method_43471((String)"gui.easycameramod.settings.camera_indicator"), (button, value) -> {
            ConfigManager.getConfig().cameraIndicator = value;
            this.updateIndicatorControlsVisibility();
        });
        this.method_37063((class_364)this.cameraIndicatorButton);
        this.cameraIndicatorScaleSlider = new ModSliderWidget(rightSideX, y + 22, buttonWidth, 20, "gui.easycameramod.settings.indicator_scale", ConfigManager.getConfig().cameraIndicatorScale, 1.0, 5.0, 0.1, (slider, value) -> {
            ConfigManager.getConfig().cameraIndicatorScale = value.floatValue();
            slider.method_25355((class_2561)class_2561.method_43469((String)"gui.easycameramod.settings.indicator_scale_value", (Object[])new Object[]{String.format("%.1f", value)}));
        }, null);
        this.method_37063((class_364)this.cameraIndicatorScaleSlider);
    }

    private void initDisplayModeControls() {
        int buttonWidth = 180;
        int rightSideX = this.field_22789 - buttonWidth - 10;
        int startY = 122;
        this.displayModeButton = class_5676.method_32606(mode -> class_2561.method_43471((String)("gui.easycameramod.settings.display_mode." + mode.name().toLowerCase()))).method_32624((Object[])Config.DisplayMode.values()).method_32619((Object)ConfigManager.getConfig().displayMode).method_32618(mode -> class_7919.method_47407((class_2561)class_2561.method_43471((String)("gui.easycameramod.settings.display_mode." + mode.name().toLowerCase() + ".tooltip")))).method_32617(rightSideX, startY, buttonWidth, 20, (class_2561)class_2561.method_43471((String)"gui.easycameramod.settings.display_mode"), (button, mode) -> {
            ConfigManager.getConfig().displayMode = mode;
            this.updateCropBoxControlsVisibility();
            this.updateLocalPreview();
            this.sendSettingsToServer();
        });
        this.method_37063((class_364)this.displayModeButton);
        int controlSpacing = 22;
        this.cropBoxXSlider = new ModSliderWidget(rightSideX, startY + controlSpacing, buttonWidth, 20, "gui.easycameramod.settings.crop_x", ConfigManager.getConfig().cropBoxX, 0.0, 1.0, 0.01, (slider, value) -> {
            float clampedX;
            Config config = ConfigManager.getConfig();
            float cropSize = config.cropBoxSize;
            if (cropSize <= 0.0f) {
                return;
            }
            float min_offset = 0.5f / cropSize;
            float max_offset = 1.0f - 0.5f / cropSize;
            config.cropBoxX = clampedX = (float)Math.max((double)min_offset, Math.min((double)max_offset, value));
            slider.method_25355((class_2561)class_2561.method_43469((String)"gui.easycameramod.settings.crop_x_value", (Object[])new Object[]{String.format("%.2f", Float.valueOf(clampedX))}));
            this.updateLocalPreview();
        }, this::sendSettingsToServer);
        this.cropBoxYSlider = new ModSliderWidget(rightSideX, startY + 2 * controlSpacing, buttonWidth, 20, "gui.easycameramod.settings.crop_y", ConfigManager.getConfig().cropBoxY, 0.0, 1.0, 0.01, (slider, value) -> {
            float clampedY;
            Config config = ConfigManager.getConfig();
            float cropSize = config.cropBoxSize;
            if (cropSize <= 0.0f) {
                return;
            }
            float min_offset = 0.5f / cropSize;
            float max_offset = 1.0f - 0.5f / cropSize;
            config.cropBoxY = clampedY = (float)Math.max((double)min_offset, Math.min((double)max_offset, value));
            slider.method_25355((class_2561)class_2561.method_43469((String)"gui.easycameramod.settings.crop_y_value", (Object[])new Object[]{String.format("%.2f", Float.valueOf(clampedY))}));
            this.updateLocalPreview();
        }, this::sendSettingsToServer);
        double initialSliderValue = ConfigManager.getConfig().cropBoxSize;
        this.cropBoxSizeSlider = new ModSliderWidget(rightSideX, startY + 3 * controlSpacing, buttonWidth, 20, "gui.easycameramod.settings.zoom", initialSliderValue, 1.0, 3.5, 0.05, (slider, value) -> {
            Config config = ConfigManager.getConfig();
            config.cropBoxSize = value.floatValue();
            slider.method_25355((class_2561)class_2561.method_43469((String)"gui.easycameramod.settings.zoom_value", (Object[])new Object[]{String.format("%.2f", value)}));
            float cropSize = config.cropBoxSize;
            if (cropSize > 0.0f) {
                float min_offset = 0.5f / cropSize;
                float max_offset = 1.0f - 0.5f / cropSize;
                config.cropBoxX = Math.max(min_offset, Math.min(max_offset, config.cropBoxX));
                config.cropBoxY = Math.max(min_offset, Math.min(max_offset, config.cropBoxY));
            }
            this.updateLocalPreview();
        }, this::sendSettingsToServer);
        this.method_37063((class_364)this.cropBoxXSlider);
        this.method_37063((class_364)this.cropBoxYSlider);
        this.method_37063((class_364)this.cropBoxSizeSlider);
    }

    private void initCameraPositionControls() {
        int buttonWidth = 180;
        int rightSideX = this.field_22789 - buttonWidth - 10;
        int startY = 220;
        int controlSpacing = 22;
        this.method_37063((class_364)new class_7842(rightSideX + buttonWidth / 2 - this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"gui.easycameramod.settings.in_world_rendering")) / 2, startY, this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"gui.easycameramod.settings.in_world_rendering")), 10, (class_2561)class_2561.method_43471((String)"gui.easycameramod.settings.in_world_rendering"), this.field_22793));
        this.cameraPositionXSlider = new ModSliderWidget(rightSideX, startY += 12, buttonWidth, 20, "gui.easycameramod.settings.offset_x", ConfigManager.getConfig().offsetX, -50.0, 50.0, 1.0, (slider, value) -> {
            ConfigManager.getConfig().offsetX = value.floatValue();
            slider.method_25355((class_2561)class_2561.method_43469((String)"gui.easycameramod.settings.offset_x_value", (Object[])new Object[]{value / 100.0}));
        }, null);
        this.cameraPositionYSlider = new ModSliderWidget(rightSideX, startY + controlSpacing, buttonWidth, 20, "gui.easycameramod.settings.offset_y", ConfigManager.getConfig().offsetY, -50.0, 250.0, 1.0, (slider, value) -> {
            ConfigManager.getConfig().offsetY = value.floatValue();
            slider.method_25355((class_2561)class_2561.method_43469((String)"gui.easycameramod.settings.offset_y_value", (Object[])new Object[]{(value - 100.0) / 100.0}));
        }, null);
        this.cameraPositionZSlider = new ModSliderWidget(rightSideX, startY + 2 * controlSpacing, buttonWidth, 20, "gui.easycameramod.settings.offset_z", ConfigManager.getConfig().offsetZ, -50.0, 50.0, 1.0, (slider, value) -> {
            ConfigManager.getConfig().offsetZ = value.floatValue();
            slider.method_25355((class_2561)class_2561.method_43469((String)"gui.easycameramod.settings.offset_z_value", (Object[])new Object[]{value / 100.0}));
        }, null);
        this.cameraScaleSlider = new ModSliderWidget(rightSideX, startY + 3 * controlSpacing, buttonWidth, 20, "gui.easycameramod.settings.scale", ConfigManager.getConfig().worldScale, 0.1, 2.0, 0.01, (slider, value) -> {
            ConfigManager.getConfig().worldScale = value.floatValue();
            slider.method_25355((class_2561)class_2561.method_43469((String)"gui.easycameramod.settings.scale_value", (Object[])new Object[]{value}));
        }, null);
        this.method_37063((class_364)this.cameraPositionXSlider);
        this.method_37063((class_364)this.cameraPositionYSlider);
        this.method_37063((class_364)this.cameraPositionZSlider);
        this.method_37063((class_364)this.cameraScaleSlider);
    }

    private void updateCropBoxControlsVisibility() {
        boolean isVisible;
        this.cropBoxXSlider.field_22764 = isVisible = ConfigManager.getConfig().displayMode == Config.DisplayMode.CROP_BOX;
        this.cropBoxYSlider.field_22764 = isVisible;
        this.cropBoxSizeSlider.field_22764 = isVisible;
    }

    private void updateIndicatorControlsVisibility() {
        this.cameraIndicatorScaleSlider.field_22764 = ConfigManager.getConfig().cameraIndicator != Config.CameraIndicator.NONE;
    }

    private void sendSettingsToServer() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null && WebcamManager.getInstance().getCurrentWebcam() != null) {
            Config config = ConfigManager.getConfig();
            C2SUpdateDisplaySettingsPayload payload = new C2SUpdateDisplaySettingsPayload(config.displayMode, config.cropBoxX, config.cropBoxY, config.cropBoxSize);
            ClientPlayNetworking.send((class_8710)payload);
        }
    }

    private void updateLocalPreview() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            Config config = ConfigManager.getConfig();
            PlayerDisplaySettings localSettings = new PlayerDisplaySettings(config.displayMode, config.cropBoxX, config.cropBoxY, config.cropBoxSize);
            PlayerDisplaySettingsManager.getInstance().updateSettings(this.field_22787.field_1724.method_5667(), localSettings);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    @Environment(value=EnvType.CLIENT)
    public class WebcamEntryList
    extends class_4265<WebcamEntry> {
        public boolean canSwitch;
        private Function<Webcam, ?> selectedCallback;

        public WebcamEntryList(class_310 client, int width, int height, int y, int itemHeight) {
            super(client, width, height, y, itemHeight);
            this.canSwitch = true;
            this.refreshWebcams();
        }

        public void refreshWebcams() {
            this.method_25339();
            this.method_25321((class_350.class_351)new WebcamEntry(null));
            List<Webcam> webcams = WebcamManager.getInstance().getWebcams();
            for (Webcam webcam : webcams) {
                this.method_25321((class_350.class_351)new WebcamEntry(webcam));
            }
            String selectedName = ConfigManager.getConfig().selectedWebcam;
            for (WebcamEntry entry : this.method_25396()) {
                if ((entry.webcam == null || !entry.webcam.getName().equals(selectedName)) && (entry.webcam != null || !selectedName.isEmpty())) continue;
                this.method_25313((class_350.class_351)entry);
                break;
            }
        }

        public void onSelected(Function<Webcam, ?> selectedCallback) {
            this.selectedCallback = selectedCallback;
        }

        @Environment(value=EnvType.CLIENT)
        public class WebcamEntry
        extends class_4265.class_4266<WebcamEntry> {
            public final Webcam webcam;
            private final Object webcamSwitchLock = new Object();

            public WebcamEntry(Webcam webcam) {
                this.webcam = webcam;
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                Object textToDraw;
                boolean isSelected;
                boolean bl = isSelected = WebcamEntryList.this.method_25334() == this;
                if (isSelected) {
                    context.method_25294(x, y, x + entryWidth, y + entryHeight, -12961222);
                } else if (hovered) {
                    context.method_25294(x, y, x + entryWidth, y + entryHeight, 0x40FFFFFF);
                }
                Object object = textToDraw = this.webcam != null ? this.webcam.getName() : class_2561.method_43471((String)"gui.easycameramod.settings.not_selected").getString();
                if (((String)textToDraw).length() > 31) {
                    textToDraw = ((String)textToDraw).substring(0, Math.min(((String)textToDraw).length(), 31)) + "...";
                }
                class_2561 text = class_2561.method_30163((String)textToDraw);
                int color = 0xFFFFFF;
                if (!WebcamEntryList.this.canSwitch || !((Boolean)SettingsScreen.this.visibleToggleButton.method_32603()).booleanValue()) {
                    color = 0xAAAAAA;
                }
                context.method_27534(SettingsScreen.this.field_22793, text, x + entryWidth / 2, y + (entryHeight - 8) / 2, color);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    Object object = this.webcamSwitchLock;
                    synchronized (object) {
                        if (WebcamEntryList.this.canSwitch && this != WebcamEntryList.this.method_25334()) {
                            WebcamEntryList.this.canSwitch = false;
                            WebcamEntryList.this.method_25313((class_350.class_351)this);
                            new Thread(() -> {
                                try {
                                    WebcamManager.getInstance().selectWebcam(this.webcam);
                                    if (this.webcam == null) {
                                        WebcamManager.getInstance().stop();
                                    } else if (ConfigManager.getConfig().webcamEnabled) {
                                        WebcamManager.getInstance().start();
                                    }
                                }
                                finally {
                                    WebcamEntryList.this.canSwitch = true;
                                }
                            }).start();
                        }
                    }
                    return true;
                }
                return super.method_25402(mouseX, mouseY, button);
            }

            public List<? extends class_6379> method_37025() {
                return Collections.emptyList();
            }

            public List<? extends class_364> method_25396() {
                return Collections.emptyList();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ModSliderWidget
    extends class_357 {
        private final double min;
        private final double max;
        private final double step;
        private final BiConsumer<ModSliderWidget, Double> onUpdate;
        private final Runnable onRelease;

        public ModSliderWidget(int x, int y, int width, int height, String key, double current, double min, double max, double step, BiConsumer<ModSliderWidget, Double> onUpdate, Runnable onRelease) {
            super(x, y, width, height, (class_2561)class_2561.method_43471((String)key), (current - min) / (max - min));
            this.min = min;
            this.max = max;
            this.step = step;
            this.onUpdate = onUpdate;
            this.onRelease = onRelease;
            this.method_25344();
        }

        protected void method_25346() {
        }

        protected void method_25344() {
            double steppedValue;
            double rawActualValue = this.min + (this.max - this.min) * this.field_22753;
            if (this.step > 0.0) {
                steppedValue = (double)Math.round(rawActualValue / this.step) * this.step;
                BigDecimal bd = new BigDecimal(steppedValue);
                bd = bd.setScale(10, RoundingMode.HALF_UP);
                steppedValue = bd.doubleValue();
            } else {
                steppedValue = rawActualValue;
            }
            steppedValue = Math.max(this.min, Math.min(this.max, steppedValue));
            this.field_22753 = (steppedValue - this.min) / (this.max - this.min);
            this.onUpdate.accept(this, steppedValue);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            if (this.onRelease != null) {
                this.onRelease.run();
            }
            return super.method_25406(mouseX, mouseY, button);
        }
    }
}

