/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_640;
import net.minecraft.class_7532;
import net.minecraft.class_8685;
import org.jetbrains.annotations.Nullable;
import ru.kawaii.easycameramod.client.MutedPlayersManager;

@Environment(value=EnvType.CLIENT)
public class WebcamMuteScreen
extends class_437 {
    private final class_437 parent;
    private PlayerListWidget playerListWidget;
    private class_342 searchField;
    private List<class_640> allPlayers = new ArrayList<class_640>();

    public WebcamMuteScreen(@Nullable class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gui.easycameramod.mute.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.field_22787 == null || this.field_22787.method_1562() == null) {
            return;
        }
        this.allPlayers = new ArrayList<class_640>(this.field_22787.method_1562().method_2880());
        this.searchField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 25, 200, 20, (class_2561)class_2561.method_43471((String)"gui.easycameramod.mute.search"));
        this.searchField.method_1863(this::onSearchChanged);
        this.method_37063((class_364)this.searchField);
        this.playerListWidget = new PlayerListWidget(this.field_22787, this.field_22789, this.field_22790, 50, this.field_22790 - 40);
        this.method_37063((class_364)this.playerListWidget);
        this.playerListWidget.filter(this.allPlayers, "");
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), btn -> this.method_25419()).method_46433(this.field_22789 / 2 - 100, this.field_22790 - 30).method_46437(200, 20).method_46431());
    }

    public void method_25419() {
        if (this.parent != null) {
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        } else {
            super.method_25419();
        }
    }

    private void onSearchChanged(String text) {
        this.playerListWidget.filter(this.allPlayers, text);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
    }

    @Environment(value=EnvType.CLIENT)
    private static class PlayerListWidget
    extends class_4265<PlayerEntry> {
        public PlayerListWidget(class_310 client, int width, int height, int top, int bottom) {
            super(client, width, height, top, 32);
        }

        public void filter(List<class_640> allPlayers, String filter) {
            this.method_25339();
            for (class_640 entry : allPlayers) {
                if (entry == null || entry.method_2966() == null) continue;
                String name = entry.method_2966().getName();
                UUID uuid = entry.method_2966().getId();
                if (uuid == null || this.field_22740 != null && uuid.equals(this.field_22740.field_1724.method_5667()) || filter != null && !filter.isEmpty() && !name.toLowerCase().contains(filter.toLowerCase())) continue;
                boolean muted = MutedPlayersManager.isMuted(uuid);
                this.method_25321((class_350.class_351)new PlayerEntry(uuid, name, muted, entry.method_52810()));
            }
        }

        public int method_25322() {
            return super.method_25322() - 6;
        }

        @Environment(value=EnvType.CLIENT)
        public static class PlayerEntry
        extends class_4265.class_4266<PlayerEntry> {
            private final UUID uuid;
            private final String name;
            private final class_4185 muteButton;
            private final class_8685 skinTextures;
            private final class_310 client = class_310.method_1551();

            public PlayerEntry(UUID uuid, String name, boolean muted, class_8685 skinTextures) {
                this.uuid = uuid;
                this.name = name;
                this.skinTextures = skinTextures;
                this.muteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)(muted ? "gui.easycameramod.mute.show" : "gui.easycameramod.mute.hide")), btn -> {
                    if (MutedPlayersManager.isMuted(uuid)) {
                        MutedPlayersManager.unmute(uuid);
                        btn.method_25355((class_2561)class_2561.method_43471((String)"gui.easycameramod.mute.hide"));
                    } else {
                        MutedPlayersManager.mute(uuid);
                        btn.method_25355((class_2561)class_2561.method_43471((String)"gui.easycameramod.mute.show"));
                    }
                }).method_46437(60, 20).method_46431();
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                int headSize = 20;
                int headX = x + 5;
                int headY = y + (entryHeight - headSize) / 2;
                class_7532.method_52722((class_332)context, (class_8685)this.skinTextures, (int)headX, (int)headY, (int)headSize);
                if (MutedPlayersManager.isMuted(this.uuid)) {
                    context.method_25294(headX, headY, headX + headSize, headY + headSize, Integer.MIN_VALUE);
                }
                class_5250 displayName = MutedPlayersManager.isMuted(this.uuid) ? class_2561.method_43470((String)this.name).method_27694(style -> style.method_36140(Boolean.valueOf(true))) : class_2561.method_43470((String)this.name);
                context.method_27535(this.client.field_1772, (class_2561)displayName, headX + headSize + 5, y + (entryHeight - 9) / 2, 0xFFFFFF);
                this.muteButton.method_48229(x + entryWidth - 70, y + (entryHeight - 20) / 2);
                this.muteButton.method_25394(context, mouseX, mouseY, tickDelta);
            }

            public List<? extends class_6379> method_37025() {
                return ImmutableList.of((Object)this.muteButton);
            }

            public List<? extends class_364> method_25396() {
                return ImmutableList.of((Object)this.muteButton);
            }
        }
    }
}

