/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import ru.kawaii.easycameramod.client.PlayerDisplaySettingsManager;
import ru.kawaii.easycameramod.client.PlayerWebcamManager;
import ru.kawaii.easycameramod.client.WebcamTextureManager;
import ru.kawaii.easycameramod.client.renderer.WebcamRenderer;
import ru.kawaii.easycameramod.config.Config;
import ru.kawaii.easycameramod.config.ConfigManager;
import ru.kawaii.easycameramod.config.PlayerDisplaySettings;

@Environment(value=EnvType.CLIENT)
public class HudRenderer {
    public static void init() {
        WebcamTextureManager textureManager = PlayerWebcamManager.getInstance().getTextureManager();
        HudRenderCallback.EVENT.register((drawContext, tickCounter) -> {
            Config config = ConfigManager.getConfig();
            if (config.webcamEnabled) {
                class_310 client = class_310.method_1551();
                if (client.field_1724 == null) {
                    return;
                }
                UUID playerUuid = client.field_1724.method_5667();
                byte[] frameData = PlayerWebcamManager.getInstance().getPlayerWebcam(playerUuid);
                if (frameData != null && config.cameraIndicator != Config.CameraIndicator.NONE) {
                    class_2960 textureId = textureManager.getTexture(playerUuid);
                    if (textureId == null) {
                        return;
                    }
                    PlayerDisplaySettings playerSettings = PlayerDisplaySettingsManager.getInstance().getSettings(playerUuid);
                    double guiScale = client.method_22683().method_4495();
                    float basePixelSize = 150.0f;
                    float desiredPixelSize = basePixelSize * config.cameraIndicatorScale;
                    float marginInPixels = 10.0f;
                    float size = desiredPixelSize / (float)guiScale;
                    float margin = marginInPixels / (float)guiScale;
                    int screenWidth = drawContext.method_51421();
                    int screenHeight = drawContext.method_51443();
                    float x = 0.0f;
                    float y = 0.0f;
                    switch (config.cameraIndicator) {
                        case TOP_LEFT: {
                            x = margin;
                            y = margin;
                            break;
                        }
                        case TOP_RIGHT: {
                            x = (float)screenWidth - size - margin;
                            y = margin;
                            break;
                        }
                        case BOTTOM_LEFT: {
                            x = margin;
                            y = (float)screenHeight - size - margin;
                            break;
                        }
                        case BOTTOM_RIGHT: {
                            x = (float)screenWidth - size - margin;
                            y = (float)screenHeight - size - margin;
                        }
                    }
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderTexture((int)0, (class_2960)textureId);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.disableCull();
                    class_289 tessellator = class_289.method_1348();
                    class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
                    drawContext.method_51448().method_22903();
                    drawContext.method_51448().method_46416(x + size / 2.0f, y + size / 2.0f, 0.0f);
                    Matrix4f positionMatrix = drawContext.method_51448().method_23760().method_23761();
                    WebcamRenderer.render((class_4588)buffer, positionMatrix, playerUuid, size, size);
                    class_286.method_43433((class_9801)buffer.method_60800());
                    drawContext.method_51448().method_22909();
                    RenderSystem.enableCull();
                    RenderSystem.disableBlend();
                }
            }
        });
    }
}

