/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.client.renderer;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_485;
import net.minecraft.class_591;
import net.minecraft.class_765;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import ru.kawaii.easycameramod.client.MutedPlayersManager;
import ru.kawaii.easycameramod.client.PlayerWebcamManager;
import ru.kawaii.easycameramod.client.WebcamTextureManager;
import ru.kawaii.easycameramod.client.renderer.WebcamRenderer;
import ru.kawaii.easycameramod.config.Config;
import ru.kawaii.easycameramod.config.ConfigManager;

@Environment(value=EnvType.CLIENT)
public class WebcamFeatureRenderer<T extends class_1309, M extends class_591<T>>
extends class_3887<T, M> {
    public WebcamFeatureRenderer(class_3883<T, M> context) {
        super(context);
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (class_310.method_1551().field_1755 instanceof class_485) {
            return;
        }
        if (!(entity instanceof class_1657) || !entity.method_5805() || MutedPlayersManager.isMuted(entity.method_5667())) {
            return;
        }
        PlayerWebcamManager webcamManager = PlayerWebcamManager.getInstance();
        if (!webcamManager.hasWebcam(entity.method_5667())) {
            return;
        }
        WebcamTextureManager textureManager = webcamManager.getTextureManager();
        class_2960 textureId = textureManager.getTexture(entity.method_5667());
        if (textureId == null) {
            return;
        }
        Config config = ConfigManager.getConfig();
        if (entity.method_5767() || entity == class_310.method_1551().field_1724 && !config.renderInWorld) {
            return;
        }
        byte[] frameData = PlayerWebcamManager.getInstance().getPlayerWebcam(entity.method_5667());
        if (frameData == null) {
            textureManager.removePlayer(entity.method_5667());
            return;
        }
        matrices.method_22903();
        Matrix4f initialModelMatrix = matrices.method_23760().method_23761();
        Quaternionf modelInverseRotation = new Quaternionf();
        modelInverseRotation.setFromUnnormalized((Matrix4fc)initialModelMatrix);
        modelInverseRotation.normalize();
        modelInverseRotation.invert();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Quaternionf cameraRotation = camera.method_23767();
        matrices.method_22907(modelInverseRotation);
        float xOffset = config.offsetX / 100.0f;
        float yOffset = (config.offsetY - 100.0f) / 100.0f - 0.8f;
        float zOffset = config.offsetZ / 100.0f;
        float finalY = entity.method_17682() + 0.3f + yOffset;
        if (entity.method_6128() || entity.method_5681()) {
            finalY += 1.0f;
        }
        matrices.method_46416(xOffset, finalY, zOffset);
        matrices.method_22907(cameraRotation);
        float scale = config.worldScale;
        matrices.method_22905(scale, scale, scale);
        matrices.method_22903();
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23576((class_2960)textureId));
        WebcamRenderer.renderInWorld(buffer, positionMatrix, entity.method_5667(), 1.0f, 1.0f, class_765.method_23687((int)15, (int)15));
        matrices.method_22909();
        matrices.method_22909();
    }
}

