/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.client.renderer;

import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import ru.kawaii.easycameramod.client.PlayerDisplaySettingsManager;
import ru.kawaii.easycameramod.config.Config;
import ru.kawaii.easycameramod.config.PlayerDisplaySettings;

@Environment(value=EnvType.CLIENT)
public class WebcamRenderer {
    private static final int CIRCLE_SEGMENTS = 64;

    public static void render(class_4588 buffer, Matrix4f positionMatrix, UUID playerUuid, float width, float height) {
        WebcamRenderer.renderCircle(buffer, positionMatrix, playerUuid, width, height, (u, v, x, y) -> buffer.method_22918(positionMatrix, x, y, 0.0f).method_22913(u, v), false);
    }

    public static void renderInWorld(class_4588 buffer, Matrix4f positionMatrix, UUID playerUuid, float width, float height, int light) {
        WebcamRenderer.renderCircle(buffer, positionMatrix, playerUuid, width, height, (u, v, x, y) -> buffer.method_22918(positionMatrix, x, y, 0.0f).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 0.0f, 1.0f), true);
    }

    private static void renderCircle(class_4588 buffer, Matrix4f positionMatrix, UUID playerUuid, float width, float height, VertexDrawer drawer, boolean isWorld) {
        PlayerDisplaySettings playerSettings = PlayerDisplaySettingsManager.getInstance().getSettings(playerUuid);
        float radius = width / 2.0f;
        for (int i = 0; i < 64; ++i) {
            float v2;
            float u2;
            float v1;
            float u1;
            float v0;
            float u0;
            float v_sin2;
            float u_cos2;
            float v_sin1;
            float u_cos1;
            float angle1 = (float)i / 64.0f * 2.0f * (float)Math.PI;
            float angle2 = (float)(i + 1) / 64.0f * 2.0f * (float)Math.PI;
            float cos1 = (float)Math.cos(angle1);
            float sin1 = (float)Math.sin(angle1);
            float cos2 = (float)Math.cos(angle2);
            float sin2 = (float)Math.sin(angle2);
            float x1 = radius * cos1;
            float y1 = radius * sin1;
            float x2 = radius * cos2;
            float y2 = radius * sin2;
            if (isWorld) {
                u_cos1 = 0.5f + 0.5f * cos1;
                v_sin1 = 0.5f - 0.5f * sin1;
                u_cos2 = 0.5f + 0.5f * cos2;
                v_sin2 = 0.5f - 0.5f * sin2;
            } else {
                u_cos1 = 0.5f + 0.5f * cos1;
                v_sin1 = 0.5f + 0.5f * sin1;
                u_cos2 = 0.5f + 0.5f * cos2;
                v_sin2 = 0.5f + 0.5f * sin2;
            }
            float base_u0 = 0.5f;
            float base_v0 = 0.5f;
            float base_u1 = u_cos1;
            float base_v1 = v_sin1;
            float base_u2 = u_cos2;
            float base_v2 = v_sin2;
            if (playerSettings.displayMode() == Config.DisplayMode.CROP_BOX) {
                float cropX = playerSettings.cropBoxX();
                float cropY = playerSettings.cropBoxY();
                float cropSize = playerSettings.cropBoxSize();
                if (cropSize == 0.0f) {
                    cropSize = 1.0f;
                }
                u0 = (base_u0 - 0.5f) / cropSize + cropX;
                v0 = (base_v0 - 0.5f) / cropSize + cropY;
                u1 = (base_u1 - 0.5f) / cropSize + cropX;
                v1 = (base_v1 - 0.5f) / cropSize + cropY;
                u2 = (base_u2 - 0.5f) / cropSize + cropX;
                v2 = (base_v2 - 0.5f) / cropSize + cropY;
            } else {
                u0 = base_u0;
                v0 = base_v0;
                u1 = base_u1;
                v1 = base_v1;
                u2 = base_u2;
                v2 = base_v2;
            }
            drawer.draw(u0, v0, 0.0f, 0.0f);
            drawer.draw(u1, v1, x1, y1);
            drawer.draw(u2, v2, x2, y2);
            drawer.draw(u2, v2, x2, y2);
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    private static interface VertexDrawer {
        public void draw(float var1, float var2, float var3, float var4);
    }
}

