/*
 * Decompiled with CFR 0.152.
 */
package ru.kawaii.easycameramod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import ru.kawaii.easycameramod.EasyCameraMod;
import ru.kawaii.easycameramod.config.Config;

public class ConfigManager {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("easycameramod.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Config config;

    public static void loadConfig() {
        try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
            config = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (config == null) {
                config = new Config();
            }
        }
        catch (IOException e) {
            config = new Config();
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            EasyCameraMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static Config getConfig() {
        if (config == null) {
            ConfigManager.loadConfig();
        }
        return config;
    }
}

