/*
 * Decompiled with CFR 0.152.
 */
package ari24.remotepaintings.commands;

import ari24.remotepaintings.RemotePaintingsMod;
import ari24.remotepaintings.registry.RemotePaintingRegistryHelper;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public class ReloadConfigCommand {
    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"reloadConfig").executes(ctx -> {
            String currentConfigUrl = RemotePaintingsMod.CONFIG.currentConfigUrl();
            if (currentConfigUrl.isEmpty()) {
                return 0;
            }
            try {
                RemotePaintingRegistryHelper.registerFromConfigUrl(currentConfigUrl);
            }
            catch (IOException | URISyntaxException e) {
                ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_30163((String)"Failed to reload config from URL").method_36136(class_2583.field_24360.method_10977(class_124.field_1061)).getFirst());
                RemotePaintingsMod.LOGGER.error("Failed to register config from URL: " + currentConfigUrl, (Throwable)e);
                return 0;
            }
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_30163((String)("Reloaded config from URL: " + currentConfigUrl)).method_36136(class_2583.field_24360.method_10977(class_124.field_1060)).getFirst());
            return 1;
        });
    }
}

