/*
 * Decompiled with CFR 0.152.
 */
package ari24.remotepaintings.commands;

import ari24.remotepaintings.RemotePaintingsMod;
import ari24.remotepaintings.registry.RemotePaintingRegistry;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveConfigCommand {
    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"saveConfig").executes(ctx -> {
            List<RemotePaintingRegistry.Entry> paintings = RemotePaintingRegistry.getAllRemotePaintings();
            JsonArray array = new JsonArray();
            for (RemotePaintingRegistry.Entry entry : paintings) {
                JsonObject obj = new JsonObject();
                obj.addProperty("name", entry.vanillaIdentifier().method_12832());
                obj.addProperty("url", entry.remoteUrl());
                array.add((JsonElement)obj);
            }
            String hasteUrl = SaveConfigCommand.uploadToHaste(array);
            if (hasteUrl != null) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_30163((String)("Uploaded and saved: " + hasteUrl)).method_36136(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, hasteUrl)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)"Click to open"))).method_10977(class_124.field_1060)).getFirst());
                RemotePaintingsMod.CONFIG.currentConfigUrl(hasteUrl);
            } else {
                ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_30163((String)"Failed to upload data to Haste.").method_36136(class_2583.field_24360.method_10977(class_124.field_1061)).getFirst());
            }
            return 1;
        });
    }

    @Nullable
    private static String uploadToHaste(JsonArray array) {
        String string;
        String jsonString = new Gson().toJson((JsonElement)array);
        String urlString = RemotePaintingsMod.CONFIG.hasteUrl();
        HttpURLConnection connection = SaveConfigCommand.writeJsonHTTP(urlString, jsonString);
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        try {
            String responseLine;
            StringBuilder response = new StringBuilder();
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine.trim());
            }
            JsonObject responseObject = (JsonObject)new Gson().fromJson(response.toString(), JsonObject.class);
            String key = responseObject.get("key").getAsString();
            string = "https://haste.pinofett.de/raw/" + key;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | URISyntaxException e) {
                RemotePaintingsMod.LOGGER.error("Failed to upload data to Haste server", (Throwable)e);
                return null;
            }
        }
        br.close();
        return string;
    }

    @NotNull
    private static HttpURLConnection writeJsonHTTP(String urlString, String jsonString) throws URISyntaxException, IOException {
        URL hasteUrl = new URI(urlString).toURL();
        HttpURLConnection connection = (HttpURLConnection)hasteUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = jsonString.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        return connection;
    }
}

