/*
 * Decompiled with CFR 0.152.
 */
package ari24.remotepaintings.mixin;

import ari24.remotepaintings.RemotePaintingsMod;
import ari24.remotepaintings.mixin.MinecraftClientAccessor;
import ari24.remotepaintings.registry.RemotePaintingRegistry;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_10049;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_928;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_928.class})
public class PaintingEntityRendererMixin {
    @Redirect(method={"render(Lnet/minecraft/client/render/entity/state/PaintingEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/PaintingEntityRenderer;renderPainting(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;[IIILnet/minecraft/client/texture/Sprite;Lnet/minecraft/client/texture/Sprite;)V"))
    private void remotePainting$injectRemovePaintingRenderer(class_928 instance, class_4587 matrices, class_4588 vertexConsumer, int[] lightmapCoordinates, int width, int height, class_1058 paintingSprite, class_1058 backSprite, @Local(argsOnly=true) class_10049 paintingEntityRenderState) {
        if (paintingEntityRenderState.field_53497 == null) {
            this.renderPainting(matrices, vertexConsumer, lightmapCoordinates, width, height, paintingSprite, backSprite, true);
            return;
        }
        @Nullable RemotePaintingRegistry.Entry remotePaintingEntry = RemotePaintingRegistry.getRemotePainting(paintingEntityRenderState.field_53497.comp_2672());
        boolean renderOriginal = remotePaintingEntry == null;
        this.renderPainting(matrices, vertexConsumer, lightmapCoordinates, width, height, paintingSprite, backSprite, renderOriginal);
    }

    @Inject(method={"render(Lnet/minecraft/client/render/entity/state/PaintingEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;pop()V")})
    private void remotePainting$injectCustomPaintingRenderer(class_10049 paintingEntityRenderState, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
        if (paintingEntityRenderState.field_53497 == null) {
            return;
        }
        @Nullable RemotePaintingRegistry.Entry remotePaintingEntry = RemotePaintingRegistry.getRemotePainting(paintingEntityRenderState.field_53497.comp_2672());
        if (remotePaintingEntry == null) {
            return;
        }
        matrixStack.method_22903();
        RenderSystem.setShaderTexture((int)0, (class_2960)remotePaintingEntry.customIdentifier());
        class_1921 layer = RemotePaintingsMod.getRemotePaintingRenderLayer(remotePaintingEntry.customIdentifier());
        class_4588 customConsumer = vertexConsumerProvider.getBuffer(layer);
        class_4587.class_4665 entry = matrixStack.method_23760();
        int width = paintingEntityRenderState.field_53497.comp_2670();
        int height = paintingEntityRenderState.field_53497.comp_2671();
        switch (remotePaintingEntry.contentType()) {
            case GIF: {
                this.renderGif(remotePaintingEntry, entry, customConsumer, width, height);
                break;
            }
            default: {
                this.renderImage(remotePaintingEntry, entry, customConsumer, width, height);
            }
        }
        matrixStack.method_22909();
    }

    @Unique
    private void renderGif(RemotePaintingRegistry.Entry remotePaintingEntry, class_4587.class_4665 entry, class_4588 vertexConsumer, int width, int height) {
        MinecraftClientAccessor accessor = (MinecraftClientAccessor)class_310.method_1551();
        float halfWidthOffset = (float)(-width) / 2.0f;
        float halfHeightOffset = (float)(-height) / 2.0f;
        float x0 = halfWidthOffset;
        float x1 = halfWidthOffset + (float)width;
        float y0 = halfHeightOffset;
        float y1 = halfHeightOffset + (float)height;
        long gameTick = accessor.getUptimeInTicks();
        float delayTicks = (float)Objects.requireNonNull(remotePaintingEntry.delayMs).intValue() / 50.0f;
        float uStepSize = 1.0f / (float)Objects.requireNonNull(remotePaintingEntry.frameCount).intValue();
        int currentFrame = (int)((float)gameTick / delayTicks % (float)Objects.requireNonNull(remotePaintingEntry.frameCount).intValue());
        float u0 = uStepSize * (float)currentFrame;
        float u1 = u0 + uStepSize;
        this.vertex(entry, vertexConsumer, x1, y0, u0, 1.0f, -0.03125f, 0, 1, 0, 0xF000F0);
        this.vertex(entry, vertexConsumer, x0, y0, u1, 1.0f, -0.03125f, 0, 1, 0, 0xF000F0);
        this.vertex(entry, vertexConsumer, x0, y1, u1, 0.0f, -0.03125f, 0, 1, 0, 0xF000F0);
        this.vertex(entry, vertexConsumer, x1, y1, u0, 0.0f, -0.03125f, 0, 1, 0, 0xF000F0);
    }

    @Unique
    private void renderImage(RemotePaintingRegistry.Entry remotePaintingEntry, class_4587.class_4665 entry, class_4588 vertexConsumer, int width, int height) {
        float halfWidthOffset = (float)(-width) / 2.0f;
        float halfHeightOffset = (float)(-height) / 2.0f;
        float x0 = halfWidthOffset;
        float x1 = halfWidthOffset + (float)width;
        float y0 = halfHeightOffset;
        float y1 = halfHeightOffset + (float)height;
        this.vertex(entry, vertexConsumer, x1, y0, 0.0f, 1.0f, -0.03125f, 0, 1, 0, 0xF000F0);
        this.vertex(entry, vertexConsumer, x0, y0, 1.0f, 1.0f, -0.03125f, 0, 1, 0, 0xF000F0);
        this.vertex(entry, vertexConsumer, x0, y1, 1.0f, 0.0f, -0.03125f, 0, 1, 0, 0xF000F0);
        this.vertex(entry, vertexConsumer, x1, y1, 0.0f, 0.0f, -0.03125f, 0, 1, 0, 0xF000F0);
    }

    @Unique
    private void renderPainting(class_4587 matrices, class_4588 vertexConsumer, int[] lightmapCoordinates, int width, int height, class_1058 paintingSprite, class_1058 backSprite, boolean renderOriginal) {
        class_4587.class_4665 entry = matrices.method_23760();
        float halfWidthOffset = (float)(-width) / 2.0f;
        float halfHeightOffset = (float)(-height) / 2.0f;
        float relLayerWidth = 0.03125f;
        float minU = backSprite.method_4594();
        float maxU = backSprite.method_4577();
        float minV = backSprite.method_4593();
        float maxV = backSprite.method_4575();
        float innerV = backSprite.method_4570(0.0625f);
        float innerU = backSprite.method_4580(0.0625f);
        double widthStep = 1.0 / (double)width;
        double heightStep = 1.0 / (double)height;
        for (int u = 0; u < width; ++u) {
            for (int v = 0; v < height; ++v) {
                float x1 = halfWidthOffset + (float)(u + 1);
                float x0 = halfWidthOffset + (float)u;
                float y1 = halfHeightOffset + (float)(v + 1);
                float y0 = halfHeightOffset + (float)v;
                int lightMap = lightmapCoordinates[u + v * width];
                float textureU0 = paintingSprite.method_4580((float)(widthStep * (double)(width - u)));
                float textureU1 = paintingSprite.method_4580((float)(widthStep * (double)(width - (u + 1))));
                float textureV0 = paintingSprite.method_4570((float)(heightStep * (double)(height - v)));
                float textureV1 = paintingSprite.method_4570((float)(heightStep * (double)(height - (v + 1))));
                if (renderOriginal) {
                    this.vertex(entry, vertexConsumer, x1, y0, textureU1, textureV0, -relLayerWidth, 0, 0, -1, lightMap);
                    this.vertex(entry, vertexConsumer, x0, y0, textureU0, textureV0, -relLayerWidth, 0, 0, -1, lightMap);
                    this.vertex(entry, vertexConsumer, x0, y1, textureU0, textureV1, -relLayerWidth, 0, 0, -1, lightMap);
                    this.vertex(entry, vertexConsumer, x1, y1, textureU1, textureV1, -relLayerWidth, 0, 0, -1, lightMap);
                }
                this.vertex(entry, vertexConsumer, x1, y1, maxU, minV, relLayerWidth, 0, 0, 1, lightMap);
                this.vertex(entry, vertexConsumer, x0, y1, minU, minV, relLayerWidth, 0, 0, 1, lightMap);
                this.vertex(entry, vertexConsumer, x0, y0, minU, maxV, relLayerWidth, 0, 0, 1, lightMap);
                this.vertex(entry, vertexConsumer, x1, y0, maxU, maxV, relLayerWidth, 0, 0, 1, lightMap);
                this.vertex(entry, vertexConsumer, x1, y1, minU, minV, -relLayerWidth, 0, 1, 0, lightMap);
                this.vertex(entry, vertexConsumer, x0, y1, maxU, minV, -relLayerWidth, 0, 1, 0, lightMap);
                this.vertex(entry, vertexConsumer, x0, y1, maxU, innerV, relLayerWidth, 0, 1, 0, lightMap);
                this.vertex(entry, vertexConsumer, x1, y1, minU, innerV, relLayerWidth, 0, 1, 0, lightMap);
                this.vertex(entry, vertexConsumer, x1, y0, minU, minV, relLayerWidth, 0, -1, 0, lightMap);
                this.vertex(entry, vertexConsumer, x0, y0, maxU, minV, relLayerWidth, 0, -1, 0, lightMap);
                this.vertex(entry, vertexConsumer, x0, y0, maxU, innerV, -relLayerWidth, 0, -1, 0, lightMap);
                this.vertex(entry, vertexConsumer, x1, y0, minU, innerV, -relLayerWidth, 0, -1, 0, lightMap);
                this.vertex(entry, vertexConsumer, x1, y1, innerU, minV, relLayerWidth, -1, 0, 0, lightMap);
                this.vertex(entry, vertexConsumer, x1, y0, innerU, maxV, relLayerWidth, -1, 0, 0, lightMap);
                this.vertex(entry, vertexConsumer, x1, y0, minU, maxV, -relLayerWidth, -1, 0, 0, lightMap);
                this.vertex(entry, vertexConsumer, x1, y1, minU, minV, -relLayerWidth, -1, 0, 0, lightMap);
                this.vertex(entry, vertexConsumer, x0, y1, innerU, minV, -relLayerWidth, 1, 0, 0, lightMap);
                this.vertex(entry, vertexConsumer, x0, y0, innerU, maxV, -relLayerWidth, 1, 0, 0, lightMap);
                this.vertex(entry, vertexConsumer, x0, y0, minU, maxV, relLayerWidth, 1, 0, 0, lightMap);
                this.vertex(entry, vertexConsumer, x0, y1, minU, minV, relLayerWidth, 1, 0, 0, lightMap);
            }
        }
    }

    @Unique
    private void vertex(class_4587.class_4665 matrix, class_4588 vertexConsumer, float x, float y, float u, float v, float z, int normalX, int normalY, int normalZ, int light) {
        vertexConsumer.method_56824(matrix, x, y, z).method_39415(-1).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_60831(matrix, (float)normalX, (float)normalY, (float)normalZ);
    }
}

