/*
 * Decompiled with CFR 0.152.
 */
package ari24.remotepaintings.registry;

import ari24.remotepaintings.registry.RemotePaintingRegistryHelper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class RemotePaintingRegistry {
    private static final Map<class_2960, Entry> registeredPaintings = new HashMap<class_2960, Entry>();

    public static void registerRemotePainting(Entry entry, class_1043 image) {
        if (registeredPaintings.containsKey(entry.vanillaIdentifier())) {
            RemotePaintingRegistry.unregisterRemotePainting(entry.vanillaIdentifier());
        }
        registeredPaintings.put(entry.vanillaIdentifier(), entry);
        class_1060 manager = class_310.method_1551().method_1531();
        manager.method_4616(entry.customIdentifier(), (class_1044)image);
    }

    public static void unregisterRemotePainting(class_2960 vanillaIdentifier) {
        Entry entry = registeredPaintings.remove(vanillaIdentifier);
        class_1060 manager = class_310.method_1551().method_1531();
        manager.method_4615(entry.customIdentifier());
    }

    @Nullable
    public static Entry getRemotePainting(class_2960 vanillaIdentifier) {
        return registeredPaintings.get(vanillaIdentifier);
    }

    public static List<Entry> getAllRemotePaintings() {
        return List.copyOf(registeredPaintings.values());
    }

    public static void reloadAll() throws IOException, URISyntaxException {
        class_2960 vanillaIdentifier;
        HashMap<class_2960, Entry> copy = new HashMap<class_2960, Entry>(registeredPaintings);
        for (Map.Entry entry : copy.entrySet()) {
            vanillaIdentifier = (class_2960)entry.getKey();
            RemotePaintingRegistry.unregisterRemotePainting(vanillaIdentifier);
        }
        for (Map.Entry entry : copy.entrySet()) {
            vanillaIdentifier = (class_2960)entry.getKey();
            Entry paintingEntry = (Entry)entry.getValue();
            RemotePaintingRegistryHelper.registerFromUrl(vanillaIdentifier.method_12832(), paintingEntry.remoteUrl());
        }
    }

    public static final class Entry {
        private final class_2960 vanillaIdentifier;
        private final class_2960 customIdentifier;
        private final String remoteUrl;
        private int pixelWidth;
        private int pixelHeight;
        private RemotePaintingRegistryHelper.ContentType contentType;
        @Nullable
        public Integer delayMs;
        @Nullable
        public Integer frameCount;

        public Entry(class_2960 vanillaIdentifier, class_2960 customIdentifier, String remoteUrl) {
            this.vanillaIdentifier = vanillaIdentifier;
            this.customIdentifier = customIdentifier;
            this.remoteUrl = remoteUrl;
        }

        public Entry(class_2960 vanillaIdentifier, class_2960 customIdentifier, String remoteUrl, int pixelWidth, int pixelHeight, RemotePaintingRegistryHelper.ContentType contentType) {
            this.vanillaIdentifier = vanillaIdentifier;
            this.customIdentifier = customIdentifier;
            this.remoteUrl = remoteUrl;
            this.pixelWidth = pixelWidth;
            this.pixelHeight = pixelHeight;
            this.contentType = contentType;
        }

        public void setDelayMs(@Nullable Integer delayMs) {
            this.delayMs = delayMs;
        }

        public void setFrameCount(@Nullable Integer frameCount) {
            this.frameCount = frameCount;
        }

        public void setPixelWidth(int pixelWidth) {
            this.pixelWidth = pixelWidth;
        }

        public void setPixelHeight(int pixelHeight) {
            this.pixelHeight = pixelHeight;
        }

        public void setContentType(RemotePaintingRegistryHelper.ContentType contentType) {
            this.contentType = contentType;
        }

        public class_2960 vanillaIdentifier() {
            return this.vanillaIdentifier;
        }

        public class_2960 customIdentifier() {
            return this.customIdentifier;
        }

        public int pixelWidth() {
            return this.pixelWidth;
        }

        public int pixelHeight() {
            return this.pixelHeight;
        }

        public String remoteUrl() {
            return this.remoteUrl;
        }

        public RemotePaintingRegistryHelper.ContentType contentType() {
            return this.contentType;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Entry that = (Entry)obj;
            return Objects.equals(this.vanillaIdentifier, that.vanillaIdentifier) && Objects.equals(this.customIdentifier, that.customIdentifier) && this.pixelWidth == that.pixelWidth && this.pixelHeight == that.pixelHeight && Objects.equals((Object)this.contentType, (Object)that.contentType);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.vanillaIdentifier, this.customIdentifier, this.pixelWidth, this.pixelHeight, this.contentType});
        }

        public String toString() {
            return "Entry[vanillaIdentifier=" + String.valueOf(this.vanillaIdentifier) + ", customIdentifier=" + String.valueOf(this.customIdentifier) + ", pixelWidth=" + this.pixelWidth + ", pixelHeight=" + this.pixelHeight + ", contentType=" + String.valueOf((Object)this.contentType) + "]";
        }
    }
}

