/*
 * Decompiled with CFR 0.152.
 */
package ari24.remotepaintings.registry;

import ari24.remotepaintings.RemotePaintingsMod;
import ari24.remotepaintings.registry.RemotePaintingRegistry;
import ari24.remotepaintings.util.GifStitcher;
import ari24.remotepaintings.util.ImageUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;

public class RemotePaintingRegistryHelper {
    public static void registerFromConfigUrl(String urlString) throws URISyntaxException, IOException, JsonSyntaxException {
        URL url = new URI(urlString).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            Gson gson = new Gson();
            JsonArray array = (JsonArray)gson.fromJson(response.toString(), JsonArray.class);
            if (array == null) {
                throw new IOException("Failed to parse JSON response from URL (might be empty?): " + urlString);
            }
            for (JsonElement element : array) {
                JsonObject obj = element.getAsJsonObject();
                String name = obj.get("name").getAsString();
                String overrideUrl = obj.get("url").getAsString();
                RemotePaintingRegistryHelper.registerFromUrl(name, overrideUrl);
            }
        }
    }

    public static void registerFromUrl(String vanillaIdentifier, String url) throws IOException, URISyntaxException {
        class_1043 image;
        class_3545<InputStream, ContentType> inputStreamPair = RemotePaintingRegistryHelper.getInputStream(url);
        InputStream inputStream = (InputStream)inputStreamPair.method_15442();
        @Nullable ContentType contentType = (ContentType)((Object)inputStreamPair.method_15441());
        if (contentType == null) {
            RemotePaintingsMod.LOGGER.error("Failed to determine content type for URL: " + url);
            return;
        }
        RemotePaintingRegistry.Entry entry = new RemotePaintingRegistry.Entry(class_2960.method_60656((String)vanillaIdentifier), class_2960.method_60655((String)"remote-paintings", (String)("remote/" + vanillaIdentifier)), url);
        entry.setContentType(contentType);
        switch (contentType.ordinal()) {
            case 2: {
                GifStitcher.GifAtlasResult result = GifStitcher.generateGifAtlas(inputStream);
                if (result == null) {
                    RemotePaintingsMod.LOGGER.error("Failed to load GIF from InputStream");
                    return;
                }
                image = result.texture();
                entry.setDelayMs(result.delayMs());
                entry.setFrameCount(result.frameCount());
                break;
            }
            case 0: {
                image = ImageUtils.retrievePng(inputStream);
                break;
            }
            case 1: {
                image = ImageUtils.retrieveGeneralImageFormat(inputStream);
                break;
            }
            default: {
                RemotePaintingsMod.LOGGER.error("Unsupported content type: " + String.valueOf((Object)contentType));
                return;
            }
        }
        if (image == null || image.method_4525() == null) {
            RemotePaintingsMod.LOGGER.error("Failed to load image from InputStream");
            return;
        }
        entry.setPixelWidth(image.method_4525().method_4307());
        entry.setPixelHeight(image.method_4525().method_4323());
        RemotePaintingRegistry.registerRemotePainting(entry, image);
    }

    private static class_3545<InputStream, @Nullable ContentType> getInputStream(String urlString) throws IOException, URISyntaxException {
        URL url = new URI(urlString).toURL();
        URLConnection connection = url.openConnection();
        connection.connect();
        String contentType = connection.getContentType();
        InputStream inputStream = connection.getInputStream();
        if (contentType == null) {
            throw new IOException("Unable to determine content type from URL: " + urlString);
        }
        ContentType type = ContentType.fromString(contentType);
        return new class_3545((Object)inputStream, (Object)type);
    }

    public static enum ContentType {
        PNG("png"),
        JPEG("jpeg", "jpg"),
        GIF("gif");

        private final List<String> extensions;

        private ContentType(String ... extensions) {
            this.extensions = Arrays.asList(extensions);
        }

        public static ContentType fromString(String contentType) {
            for (ContentType type : ContentType.values()) {
                if (!type.extensions.stream().anyMatch(contentType::contains)) continue;
                return type;
            }
            return null;
        }
    }
}

