/*
 * Decompiled with CFR 0.152.
 */
package ari24.remotepaintings.util;

import ari24.remotepaintings.RemotePaintingsMod;
import ari24.remotepaintings.util.GifDecoder;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;

public class GifStitcher {
    public static GifAtlasResult generateGifAtlas(InputStream inputStream) {
        GifDecoder decoder = new GifDecoder();
        int status = decoder.read(inputStream);
        if (status != 0) {
            RemotePaintingsMod.LOGGER.error("Failed to read GIF: " + status);
            return null;
        }
        int frameCount = decoder.getFrameCount();
        int maxWidth = 0;
        int maxHeight = 0;
        BufferedImage[] frames = new BufferedImage[frameCount];
        for (int i = 0; i < frameCount; ++i) {
            BufferedImage frame;
            frames[i] = frame = decoder.getFrame(i);
            maxWidth = Math.max(maxWidth, frame.getWidth());
            maxHeight = Math.max(maxHeight, frame.getHeight());
        }
        try (class_1011 stitchedTexture = new class_1011(class_1011.class_1012.field_4997, maxWidth * frameCount, maxHeight, false);){
            for (int i = 0; i < frameCount; ++i) {
                BufferedImage frame = frames[i];
                int width = frame.getWidth();
                int height = frame.getHeight();
                int xOffset = maxWidth * i + (maxWidth - width) / 2;
                int yOffset = (maxHeight - height) / 2;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int rgb = frame.getRGB(x, y);
                        stitchedTexture.method_61941(x + xOffset, y + yOffset, rgb);
                    }
                }
            }
            int delay = decoder.delay;
            if (delay == 0) {
                float aveDelay = 0.0f;
                for (int i = 0; i < frameCount; ++i) {
                    aveDelay += (float)decoder.getDelay(i);
                }
                delay = (int)Math.floor(aveDelay /= (float)frameCount);
            }
            GifAtlasResult gifAtlasResult = new GifAtlasResult(new class_1043(stitchedTexture), maxWidth * frameCount, maxHeight, frameCount, delay);
            return gifAtlasResult;
        }
    }

    public record GifAtlasResult(class_1043 texture, int pixelWidth, int pixelHeight, int frameCount, int delayMs) {
    }
}

