/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.whisent.kubeloader.Config;
import com.whisent.kubeloader.event.KubeLoaderClientEventHandler;
import com.whisent.kubeloader.impl.ContentPackProviders;
import com.whisent.kubeloader.impl.dummy.DummyContentPack;
import com.whisent.kubeloader.impl.dummy.DummyContentPackProvider;
import com.whisent.kubeloader.impl.mod.ModContentPackProvider;
import com.whisent.kubeloader.impl.path.PathContentPackProvider;
import com.whisent.kubeloader.impl.path.PathContentPackRepositorySource;
import com.whisent.kubeloader.impl.zip.ZipContentPackProvider;
import com.whisent.kubeloader.impl.zip.ZipContentPackRepositorySource;
import com.whisent.kubeloader.network.NetworkHandler;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJSPaths;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="kubeloader")
public class Kubeloader {
    public static final String MODID = "kubeloader";
    public static final String FOLDER_NAME = "contentpacks";
    public static final String MIXIN_FOLDER = "mixin_scripts";
    public static final String MIXIN_IDENTIFIER = "KLM";
    public static final String CONFIG_FOLDER = "config";
    public static final Logger LOGGER = LogManager.getLogger((String)"kubeloader");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String META_DATA_FILE_NAME = "contentpack.json";
    public static Path PackPath = KubeJSPaths.DIRECTORY.resolve("contentpacks");
    public static Path ConfigPath = KubeJSPaths.DIRECTORY.resolve("config");
    public static Path MixinPath = KubeJSPaths.DIRECTORY.resolve("mixin_scripts");
    public static Path MixinLogPath = Platform.getGameFolder().resolve("logs").resolve("kubejs");

    public Kubeloader() throws IOException {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (Files.notExists(PackPath, new LinkOption[0])) {
            Files.createDirectories(PackPath, new FileAttribute[0]);
        }
        if (Files.notExists(ConfigPath, new LinkOption[0])) {
            Files.createDirectories(ConfigPath, new FileAttribute[0]);
        }
        if (Files.notExists(MixinPath, new LinkOption[0])) {
            Files.createDirectories(MixinPath, new FileAttribute[0]);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(this::ModLoading);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::injectPacks);
        KubeLoaderClientEventHandler.init();
        Kubeloader.registerModContentPackProviders();
        ContentPackProviders.register(new PathContentPackProvider(PackPath), new ZipContentPackProvider(PackPath), new DummyContentPackProvider(List.of(new DummyContentPack("kubejs", null))));
    }

    private static void registerModContentPackProviders() {
        List<ModContentPackProvider> providers = ModList.get().getMods().stream().map(ModContentPackProvider::new).toList();
        ContentPackProviders.register(providers);
    }

    private void ModLoading(FMLCommonSetupEvent event) {
        event.enqueueWork(NetworkHandler::register);
        LOGGER.info("Setup\u542f\u52a8\u4e8b\u4ef6");
    }

    private void injectPacks(AddPackFindersEvent event) {
        switch (event.getPackType()) {
            case CLIENT_RESOURCES: {
                event.addRepositorySource((RepositorySource)new PathContentPackRepositorySource(PackType.CLIENT_RESOURCES));
                event.addRepositorySource((RepositorySource)new ZipContentPackRepositorySource(PackType.CLIENT_RESOURCES));
                break;
            }
            case SERVER_DATA: {
                event.addRepositorySource((RepositorySource)new PathContentPackRepositorySource(PackType.SERVER_DATA));
                event.addRepositorySource((RepositorySource)new ZipContentPackRepositorySource(PackType.SERVER_DATA));
            }
        }
    }

    @Deprecated
    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="kubeloader", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

