/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.cpconfig;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonReader {
    public static Map<String, Object> loadConfig(Path configPath) {
        try {
            JsonObject json = JsonReader.getJsonObject(configPath);
            return JsonReader.parseJsonObject(json);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, Object>();
        }
    }

    public static JsonObject getJsonObject(Path jsonPath) {
        try {
            String jsonString = Files.readString(jsonPath);
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> parseJsonObject(JsonObject json) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            result.put(key, JsonReader.parseJsonElement(value));
        }
        return result;
    }

    private static Object parseJsonElement(JsonElement element) {
        if (element.isJsonObject()) {
            return JsonReader.parseJsonObject(element.getAsJsonObject());
        }
        if (element.isJsonArray()) {
            return JsonReader.parseJsonArray(element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
        } else if (element.isJsonNull()) {
            return null;
        }
        return "Unsupported JSON Type";
    }

    private static List<Object> parseJsonArray(JsonArray jsonArray) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonElement element : jsonArray) {
            list.add(JsonReader.parseJsonElement(element));
        }
        return list;
    }
}

