/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.definition;

import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.PackLoadingContext;
import com.whisent.kubeloader.definition.meta.PackMetaData;
import com.whisent.kubeloader.definition.meta.dependency.DependencySource;
import com.whisent.kubeloader.definition.meta.dependency.DependencyType;
import com.whisent.kubeloader.definition.meta.dependency.PackDependency;
import com.whisent.kubeloader.files.FileIO;
import com.whisent.kubeloader.impl.depends.ImmutableDependency;
import com.whisent.kubeloader.impl.depends.ImmutableMetaData;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptPackInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.forgespi.language.IModInfo;

public class ContentPackUtils {
    public static ScriptPack createEmptyPack(PackLoadingContext context, String id) {
        return new ScriptPack(context.manager(), new ScriptPackInfo(id, ""));
    }

    public static DataResult<PackMetaData> loadMetaData(InputStream stream) {
        DataResult dataResult;
        block8: {
            BufferedReader reader = FileIO.stream2reader(stream);
            try {
                JsonObject json = (JsonObject)Kubeloader.GSON.fromJson((Reader)reader, JsonObject.class);
                dataResult = PackMetaData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return DataResult.error(e::toString);
                }
            }
            reader.close();
        }
        return dataResult;
    }

    public static DataResult<PackMetaData> loadMetaData(Path path) {
        DataResult dataResult;
        block8: {
            BufferedReader reader = FileIO.file2reader(path.toFile());
            try {
                JsonObject json = (JsonObject)Kubeloader.GSON.fromJson((Reader)reader, JsonObject.class);
                dataResult = PackMetaData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return DataResult.error(e::toString);
                }
            }
            reader.close();
        }
        return dataResult;
    }

    public static PackMetaData loadMetaDataOrThrow(InputStream stream) {
        DataResult<PackMetaData> result = ContentPackUtils.loadMetaData(stream);
        if (result.error().isPresent()) {
            throw new RuntimeException(((DataResult.PartialResult)result.error().get()).message());
        }
        return (PackMetaData)result.result().orElseThrow();
    }

    public static PackMetaData loadMetaDataOrThrow(Path path) {
        DataResult<PackMetaData> result = ContentPackUtils.loadMetaData(path);
        if (result.error().isPresent()) {
            throw new RuntimeException(((DataResult.PartialResult)result.error().get()).message());
        }
        return (PackMetaData)result.result().orElseThrow();
    }

    public static PackMetaData metadataFromMod(IModInfo mod) {
        return new ImmutableMetaData(mod.getModId(), Optional.of(mod.getDisplayName()), Optional.of(mod.getDescription()), Optional.of(mod.getVersion()), List.of(), mod.getDependencies().stream().map(ContentPackUtils::dependencyFromMod).toList());
    }

    public static PackDependency dependencyFromMod(IModInfo.ModVersion modDep) {
        return new ImmutableDependency(modDep.isMandatory() ? DependencyType.REQUIRED : DependencyType.OPTIONAL, DependencySource.MOD, modDep.getModId(), Optional.of(modDep.getVersionRange()), modDep.getReferralURL().map(URL::toString), Optional.empty());
    }
}

