/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.definition.meta.dependency;

import com.whisent.kubeloader.definition.meta.dependency.DependencySource;
import com.whisent.kubeloader.definition.meta.dependency.DependencyType;
import com.whisent.kubeloader.definition.meta.dependency.LoadOrdering;
import com.whisent.kubeloader.definition.meta.dependency.PackDependency;
import com.whisent.kubeloader.impl.depends.ImmutableDependency;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class PackDependencyBuilder {
    private DependencyType type;
    private DependencySource source = DependencySource.PACK;
    private String id;
    private VersionRange versionRange;
    private String reason;
    private LoadOrdering ordering;

    public static PackDependencyBuilder create(DependencyType type, String id) {
        return new PackDependencyBuilder(type, id);
    }

    private PackDependencyBuilder(DependencyType type, String id) {
        this.type = Objects.requireNonNull(type);
        this.id = Objects.requireNonNull(id);
    }

    public PackDependencyBuilder withSource(DependencySource source) {
        this.source = Objects.requireNonNull(source);
        return this;
    }

    public PackDependencyBuilder withVersionRange(VersionRange versionRange) {
        this.versionRange = versionRange;
        return this;
    }

    public PackDependencyBuilder withVersionRange(String versionSpec) throws InvalidVersionSpecificationException {
        this.versionRange = VersionRange.createFromVersionSpec((String)versionSpec);
        return this;
    }

    public PackDependencyBuilder withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public PackDependencyBuilder withOrdering(LoadOrdering ordering) {
        this.ordering = ordering;
        return this;
    }

    public PackDependency build() {
        return new ImmutableDependency(this.type, this.source, this.id, Optional.ofNullable(this.versionRange), Optional.ofNullable(this.reason), Optional.ofNullable(this.ordering));
    }
}

