/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.event;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.meta.PackMetaData;
import com.whisent.kubeloader.utils.mod_gen.ContentPackGenerator;
import com.whisent.kubeloader.utils.mod_gen.ContentPackModInfo;
import com.whisent.kubeloader.utils.mod_gen.PackModGenerator;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kubeloader", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class KubeLoaderServerEventHandler {
    private static final Map<String, PackMetaData> packMetaDataMap = new ConcurrentHashMap<String, PackMetaData>();
    private static final Map<String, ContentPackModInfo> contentPackModInfoMap = new ConcurrentHashMap<String, ContentPackModInfo>();

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        Kubeloader.LOGGER.info("Registering commands for KubeLoader");
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder klCmd = Commands.m_82127_((String)"kl");
        klCmd.then(Commands.m_82127_((String)"mod").then(Commands.m_82129_((String)"modInfo", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> KubeLoaderServerEventHandler.suggestMapKeys(contentPackModInfoMap.keySet(), builder)).executes(ctx -> {
            String modInfo = (String)ctx.getArgument("modInfo", String.class);
            if (!contentPackModInfoMap.containsKey(modInfo)) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown mod info: " + modInfo)));
                return 0;
            }
            try {
                PackModGenerator.generateMod(contentPackModInfoMap.get(modInfo), ((CommandSourceStack)ctx.getSource()).m_230896_());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 1;
        })));
        klCmd.then(Commands.m_82127_((String)"pack").then(Commands.m_82129_((String)"metadata", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> KubeLoaderServerEventHandler.suggestMapKeys(packMetaDataMap.keySet(), builder)).executes(ctx -> {
            String metadata = (String)ctx.getArgument("metadata", String.class);
            if (!packMetaDataMap.containsKey(metadata)) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown pack metadata: " + metadata)));
                return 0;
            }
            try {
                ContentPackGenerator.generateContentPack(packMetaDataMap.get(metadata), ((CommandSourceStack)ctx.getSource()).m_230896_());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 1;
        })));
        dispatcher.register(klCmd);
    }

    private static CompletableFuture<Suggestions> suggestMapKeys(Set<String> keys, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(keys, (SuggestionsBuilder)builder);
    }

    private static Map<String, PackMetaData> getPackMetaDataMap() {
        return packMetaDataMap;
    }

    private static Map<String, ContentPackModInfo> getContentPackModInfoMap() {
        return contentPackModInfoMap;
    }

    public static void putMetaData(String id, PackMetaData metaData) {
        packMetaDataMap.put(id, metaData);
    }

    public static void putContentPackModInfo(String id, ContentPackModInfo modInfo) {
        contentPackModInfoMap.put(id, modInfo);
    }

    public static void init() {
        packMetaDataMap.clear();
        contentPackModInfoMap.clear();
    }
}

