/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.files;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.meta.PackMetaData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;

public class FileIO {
    private static final String FIXED_JSON_CONTENT = "{\n  \"pack\": {\n    \"pack_format\": 15,\n    \"description\": \"KubeLoader Resource Pack\"\n  }\n}\n";

    public static void copyAndReplaceAllFiles(Path sourceDir, Path targetDir) throws IOException {
        if (!Files.exists(sourceDir, new LinkOption[0])) {
            throw new NoSuchFileException("Source directory does not exist: " + sourceDir);
        }
        if (!Files.isDirectory(sourceDir, new LinkOption[0])) {
            throw new NotDirectoryException("Source is not a directory: " + sourceDir);
        }
        if (Files.exists(targetDir, new LinkOption[0])) {
            FileIO.deleteDirectoryRecursively(targetDir, targetDir.getParent());
        }
        Files.createDirectories(targetDir, new FileAttribute[0]);
        try (Stream<Path> stream = Files.walk(sourceDir, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(source -> {
                try {
                    Path relativePath = sourceDir.relativize((Path)source);
                    Path target = targetDir.resolve(relativePath);
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to copy: " + source + " -> " + targetDir, e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error during copy: " + source, e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Error during file copy", e);
        }
        System.out.println("\u2705 All files copied and replaced successfully from " + sourceDir + " to " + targetDir);
    }

    public static void copy(Path source, Path target) throws IOException {
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
    }

    public static List<String> listZips(Path path) {
        try {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new SecurityException("Access denied: Path is not a directory: " + path);
            }
            List<String> a = Files.list(path).filter(e -> e.getFileName().toString().endsWith(".zip")).map(Path::toString).collect(Collectors.toList());
            return a;
        }
        catch (IOException | RuntimeException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static void deleteDirectoryRecursively(Path dir, final Path basePath) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.startsWith(basePath)) {
                        Kubeloader.LOGGER.warn("Attempt to delete file outside of allowed base path: " + file);
                        return FileVisitResult.CONTINUE;
                    }
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        if (!dir.startsWith(basePath)) {
                            Kubeloader.LOGGER.warn("Attempt to delete directory outside of allowed base path: " + dir);
                            return FileVisitResult.CONTINUE;
                        }
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractAssetCopyFromZip(Path zipFilePath, String subDir) throws IOException {
        Path tempDir = Files.createTempDirectory("zip_extract", new FileAttribute[0]);
        try {
            FileIO.unzipFile(zipFilePath, tempDir);
            Path metaDir = tempDir.resolve("contentpack.json");
            Path namespaceDir = tempDir;
            Path sourceSubDir = namespaceDir.resolve(subDir);
            if (!Files.exists(sourceSubDir, new LinkOption[0])) {
                return;
            }
            Path targetDir = Minecraft.m_91087_().f_91069_.toPath().resolve("kubejs").resolve("pack_resources").resolve(subDir).resolve(namespaceDir.getFileName()).resolve(subDir);
            FileIO.copyAndReplaceAllFiles(sourceSubDir, targetDir);
        }
        finally {
            FileIO.deleteDirectoryRecursively(tempDir, tempDir.getParent());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackMetaData loadMetaData(Path base) {
        try (BufferedReader reader = Files.newBufferedReader(base.resolve("contentpack.json"));){
            DataResult result = PackMetaData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)Kubeloader.GSON.fromJson((Reader)reader, JsonObject.class)));
            if (result.result().isPresent()) {
                PackMetaData packMetaData = (PackMetaData)result.result().get();
                return packMetaData;
            }
            String errorMessage = ((DataResult.PartialResult)result.error().orElseThrow()).message();
            throw new RuntimeException("Error when parsing metadata: " + errorMessage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unzipFile(Path zipFilePath, Path destDir) throws IOException {
        if (!Files.isReadable(zipFilePath)) {
            throw new IOException("\u65e0\u6cd5\u8bfb\u53d6ZIP\u6587\u4ef6: " + zipFilePath.toAbsolutePath());
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFilePath.toFile()));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                Path filePath = destDir.resolve(zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(filePath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                    Files.copy(zis, filePath, StandardCopyOption.REPLACE_EXISTING);
                }
                zis.closeEntry();
            }
        }
    }

    private static Path validateNamespace(Path tempDir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tempDir);){
            Path namespaceDir = null;
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    if (namespaceDir != null) {
                        Path path = null;
                        return path;
                    }
                    namespaceDir = entry;
                    continue;
                }
                throw new IOException("ZIP\u6587\u4ef6\u7684\u6839\u76ee\u5f55\u5305\u542b\u975e\u76ee\u5f55\u6761\u76ee: " + entry.getFileName());
            }
            Iterator<Path> iterator = namespaceDir;
            return iterator;
        }
    }

    public static void createMcMetaFile(String filePath) throws IOException {
        Path parentDir = Paths.get(filePath, new String[0]).getParent();
        if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        try (FileWriter writer = new FileWriter(filePath.toString());){
            writer.write(FIXED_JSON_CONTENT);
        }
    }

    public static void deleteAllContents(Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException("\u8def\u5f84\u4e0d\u5b58\u5728: " + path.toAbsolutePath());
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55: " + path.toAbsolutePath());
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path entry : stream) {
                FileIO.deleteRecursively(entry);
            }
        }
        catch (IOException e) {
            throw new IOException("\u65e0\u6cd5\u8bfb\u53d6\u76ee\u5f55\u5185\u5bb9: " + path.toAbsolutePath(), e);
        }
    }

    private static void deleteRecursively(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path entry : stream) {
                    FileIO.deleteRecursively(entry);
                }
            }
        }
        Files.delete(path);
    }

    public static BufferedReader stream2reader(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public static BufferedReader file2reader(File file) throws FileNotFoundException {
        return new BufferedReader(new FileReader(file));
    }
}

