/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.files;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.jetbrains.annotations.NotNull;

public class ResourcePackProvider
implements RepositorySource {
    private final PackType type;
    private final List<File> directories;
    private final PackSource sourceInfo;

    public ResourcePackProvider(Path resourceDir, PackType type) {
        this.type = type;
        this.sourceInfo = PackSource.m_247176_(name -> Component.m_237113_((String)"KubeLoader"), (boolean)true);
        this.directories = new ArrayList<File>();
        this.directories.add(resourceDir.resolve(type.m_10305_()).toFile());
        for (File directory : this.directories) {
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (directory.isDirectory()) continue;
            throw new IllegalStateException("LOAD FAILD from non-directory. " + directory.getAbsolutePath());
        }
    }

    public void m_7686_(@NotNull Consumer<Pack> consumer) {
        for (File directory : this.directories) {
            for (File file : Objects.requireNonNull(directory.listFiles())) {
                MutableComponent displayName;
                String packName;
                Pack pack;
                boolean isFolderPack = Files.isDirectory(file.toPath(), new LinkOption[0]);
                if (!isFolderPack || (pack = Pack.m_245429_((String)(packName = file.getName()), (Component)(displayName = Component.m_237113_((String)packName)), (boolean)true, (Pack.ResourcesSupplier)this.createPackSupplier(file), (PackType)this.type, (Pack.Position)Pack.Position.TOP, (PackSource)this.sourceInfo)) == null) continue;
                consumer.accept(pack);
            }
        }
    }

    private Pack.ResourcesSupplier createPackSupplier(File packFile) {
        return name -> packFile.isDirectory() ? new PathPackResources(name, packFile.toPath(), false) : new FilePackResources(name, packFile, false);
    }
}

