/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl;

import com.whisent.kubeloader.definition.ContentPack;
import com.whisent.kubeloader.definition.ContentPackProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ContentPackProviders {
    private static List<? extends ContentPack> cachedPacks = null;
    private static final List<ContentPackProvider> STATIC_PROVIDERS = new ArrayList<ContentPackProvider>();
    private static final List<ContentPackProvider> DYNAMIC_PROVIDERS = new ArrayList<ContentPackProvider>();

    public static void register(Collection<? extends ContentPackProvider> providers) {
        for (ContentPackProvider contentPackProvider : providers) {
            if (contentPackProvider.isDynamic()) {
                DYNAMIC_PROVIDERS.add(contentPackProvider);
                continue;
            }
            STATIC_PROVIDERS.add(contentPackProvider);
        }
    }

    public static void register(ContentPackProvider ... providers) {
        ContentPackProviders.register(Arrays.asList(providers));
    }

    public static List<ContentPackProvider> getDynamicProviders() {
        return Collections.unmodifiableList(DYNAMIC_PROVIDERS);
    }

    public static List<ContentPackProvider> getStaticProviders() {
        return Collections.unmodifiableList(STATIC_PROVIDERS);
    }

    public static List<ContentPack> getPacks() {
        if (cachedPacks == null) {
            cachedPacks = STATIC_PROVIDERS.stream().map(ContentPackProvider::providePack).flatMap(Collection::stream).filter(Objects::nonNull).toList();
        }
        ArrayList<ContentPack> packs = new ArrayList<ContentPack>(cachedPacks);
        for (ContentPackProvider provider : DYNAMIC_PROVIDERS) {
            packs.addAll(provider.providePack());
        }
        return packs;
    }
}

