/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl.depends;

import com.whisent.kubeloader.definition.meta.dependency.DependencyType;
import com.whisent.kubeloader.definition.meta.dependency.LoadOrdering;
import com.whisent.kubeloader.definition.meta.dependency.PackDependency;
import com.whisent.kubeloader.impl.depends.SortableContentPack;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PackDependencyBuilder {
    public void build(Collection<SortableContentPack> sortables) {
        Map indexed = sortables.stream().collect(Collectors.toMap(SortableContentPack::id, Function.identity()));
        for (SortableContentPack sortable : sortables) {
            for (PackDependency dependency : sortable.pack().getMetaData().dependencies()) {
                if (dependency.type() != DependencyType.REQUIRED && dependency.type() != DependencyType.OPTIONAL) continue;
                SortableContentPack target = (SortableContentPack)indexed.get(dependency.id());
                if (dependency.type() == DependencyType.OPTIONAL && target == null) continue;
                switch (dependency.ordering().orElse(LoadOrdering.NONE)) {
                    case NONE: {
                        break;
                    }
                    case AFTER: {
                        sortable.getTopoDependencies().add(target);
                        break;
                    }
                    case BEFORE: {
                        target.getTopoDependencies().add(sortable);
                    }
                }
            }
        }
    }
}

