/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl.depends;

import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.ContentPack;
import com.whisent.kubeloader.definition.meta.dependency.DependencySource;
import com.whisent.kubeloader.definition.meta.dependency.DependencyType;
import com.whisent.kubeloader.definition.meta.dependency.PackDependency;
import com.whisent.kubeloader.impl.depends.DependencyReport;
import dev.architectury.platform.Platform;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class PackDependencyValidator {
    private final DupeHandling duplicationHandling;
    private Map<String, ContentPack> named;

    public PackDependencyValidator(DupeHandling duplicationHandling) {
        this.duplicationHandling = Objects.requireNonNull(duplicationHandling);
    }

    public DependencyReport validate(Collection<ContentPack> packs) {
        DependencyReport report = new DependencyReport();
        this.named = this.indexByName(packs, report);
        if (!report.errors().isEmpty() && this.duplicationHandling == DupeHandling.ERROR) {
            return report;
        }
        for (ContentPack pack : packs) {
            for (PackDependency dependency : pack.getMetaData().dependencies()) {
                this.validateSingle(pack, dependency, report);
            }
        }
        this.named = null;
        return report;
    }

    protected void validateSingle(ContentPack pack, PackDependency dependency, DependencyReport report) {
        boolean targetPresent;
        DefaultArtifactVersion targetVersion = switch (dependency.source()) {
            case DependencySource.PACK -> {
                Object target = this.named.get(dependency.id());
                targetPresent = target != null;
                yield targetPresent ? (ArtifactVersion)target.getMetaData().version().orElse(null) : null;
            }
            case DependencySource.MOD -> {
                Object target = Platform.getMod((String)dependency.id());
                targetPresent = target != null;
                yield targetPresent ? new DefaultArtifactVersion(target.getVersion()) : null;
            }
            default -> throw new IllegalStateException("Unexpected dependency source: " + dependency.source());
        };
        DependencyType type = dependency.type();
        switch (type) {
            case REQUIRED: 
            case OPTIONAL: 
            case RECOMMENDED: {
                Consumer<Component> reporter = switch (type) {
                    case DependencyType.REQUIRED -> report::addError;
                    case DependencyType.OPTIONAL -> report::addWarning;
                    case DependencyType.RECOMMENDED -> report::addInfo;
                    default -> throw new IllegalStateException();
                };
                if (!targetPresent) {
                    reporter.accept((Component)dependency.toReport(pack).m_130946_(", but ContentPack with such id is not present"));
                    break;
                }
                if (!dependency.versionRange().isPresent()) break;
                if (targetVersion == null) {
                    reporter.accept((Component)dependency.toReport(pack).m_130946_(", but ContentPack with such id did not provide a version info"));
                    break;
                }
                if (dependency.versionRange().get().containsVersion((ArtifactVersion)targetVersion)) break;
                reporter.accept((Component)dependency.toReport(pack).m_130946_(", but ContentPack with such id is at version '%s'".formatted(targetVersion)));
                break;
            }
            case INCOMPATIBLE: 
            case DISCOURAGED: {
                Consumer<Component> reporter;
                if (!targetPresent) {
                    return;
                }
                Consumer<Component> consumer = type == DependencyType.INCOMPATIBLE ? report::addError : (reporter = report::addWarning);
                if (dependency.versionRange().isEmpty()) {
                    reporter.accept((Component)dependency.toReport(pack).m_130946_(", but ContentPack with such id exists"));
                    break;
                }
                if (targetVersion == null) {
                    reporter.accept((Component)dependency.toReport(pack).m_130946_(", but ContentPack with such id did not provide version information"));
                    break;
                }
                if (!dependency.versionRange().get().containsVersion((ArtifactVersion)targetVersion)) break;
                reporter.accept((Component)dependency.toReport(pack).m_130946_(", but ContentPack with such id is at version '%s'".formatted(targetVersion)));
            }
        }
    }

    private Map<String, ContentPack> indexByName(Collection<ContentPack> packs, DependencyReport report) {
        HashMap<String, ContentPack> named = new HashMap<String, ContentPack>();
        for (ContentPack pack : packs) {
            String namespace = pack.id();
            ContentPack old = named.get(namespace);
            if (old == null) {
                named.put(namespace, pack);
                continue;
            }
            MutableComponent error = Component.m_237110_((String)"ContentPack %s and %s declared the same namespace '%s'", (Object[])new Object[]{old, pack, namespace});
            switch (this.duplicationHandling) {
                case ERROR: {
                    report.addError((Component)error);
                    break;
                }
                case PREFER_LAST: {
                    named.put(namespace, pack);
                    Kubeloader.LOGGER.warn(Component.m_237119_().m_7220_((Component)error).m_130946_(", overwriting old one").getString());
                    break;
                }
                case PREFER_FIRST: {
                    Kubeloader.LOGGER.warn(Component.m_237119_().m_7220_((Component)error).m_130946_(", keeping old one").getString());
                }
            }
        }
        return named;
    }

    public static enum DupeHandling {
        ERROR,
        PREFER_FIRST,
        PREFER_LAST;

    }
}

