/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl.mod;

import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.ContentPackUtils;
import com.whisent.kubeloader.definition.PackLoadingContext;
import com.whisent.kubeloader.definition.meta.PackMetaData;
import com.whisent.kubeloader.impl.ContentPackBase;
import com.whisent.kubeloader.mixinjs.MixinManager;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSL;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSLParser;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;

public class ModContentPack
extends ContentPackBase {
    private final IModInfo mod;

    public ModContentPack(IModInfo mod, PackMetaData metaData) {
        super(metaData);
        this.mod = mod;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected ScriptPack createPack(PackLoadingContext context) {
        this.loadMixins(context);
        ScriptPack pack = ContentPackUtils.createEmptyPack(context, this.id());
        String prefix = "contentpacks/" + context.folderName() + "/";
        try (JarFile file = new JarFile(this.mod.getOwningFile().getFile().getFilePath().toFile());){
            ZipEntry parent = file.getEntry("contentpacks/" + context.folderName());
            if (parent == null || !parent.isDirectory()) {
                ScriptPack scriptPack = null;
                return scriptPack;
            }
            file.stream().filter(e -> !e.isDirectory()).filter(e -> e.getName().endsWith(".js")).filter(e -> e.getName().startsWith(prefix)).forEach(jarEntry -> {
                ScriptFileInfo fileInfo = new ScriptFileInfo(pack.info, jarEntry.getName());
                ScriptSource scriptSource = info -> {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream((ZipEntry)jarEntry)));
                    return reader.lines().toList();
                };
                context.loadFile(pack, fileInfo, scriptSource);
            });
            ScriptPack scriptPack = pack;
            return scriptPack;
        }
        catch (IOException e2) {
            return null;
        }
    }

    public void loadMixins(PackLoadingContext context) {
        if (context.manager().scriptType.isStartup() || UtilsJS.staticServer != null) {
            String mixinFolder = "mixin_scripts/";
            try (JarFile file = new JarFile(this.mod.getOwningFile().getFile().getFilePath().toFile());){
                file.stream().filter(e -> !e.isDirectory()).filter(e -> e.getName().endsWith(".js")).filter(e -> e.getName().startsWith(mixinFolder)).forEach(jarEntry -> {
                    try {
                        String sourceCode = new BufferedReader(new InputStreamReader(file.getInputStream((ZipEntry)jarEntry))).lines().reduce("", (a, b) -> a + "\n" + b);
                        String targetFile = this.extractTargetFileFromComments(sourceCode);
                        List<MixinDSL> dsls = MixinDSLParser.parse(sourceCode);
                        String fullPath = "mod:" + this.mod.getModId() + "!/" + jarEntry.getName();
                        for (MixinDSL dsl : dsls) {
                            if (targetFile != null && !targetFile.isEmpty()) {
                                dsl.setTargetFile(targetFile);
                            } else {
                                dsl.setTargetFile(fullPath);
                            }
                            MixinManager.addMixinDSL(fullPath, dsl);
                        }
                        if (!dsls.isEmpty()) {
                            Kubeloader.LOGGER.info("Loaded {} mixin DSLs from mod JAR entry: {}", (Object)dsls.size(), (Object)fullPath);
                        }
                    }
                    catch (IOException e) {
                        Kubeloader.LOGGER.error("Failed to read mixin file from mod JAR: {}", (Object)jarEntry.getName(), (Object)e);
                    }
                });
            }
            catch (IOException e2) {
                Kubeloader.LOGGER.error("Failed to load mixins from mod: {}", (Object)this.mod.getModId(), (Object)e2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractTargetFileFromComments(String sourceCode) {
        try (BufferedReader reader = new BufferedReader(new StringReader(sourceCode));){
            Matcher matcher;
            String line;
            String trimmedLine;
            do {
                if ((line = reader.readLine()) == null) return null;
            } while (!(trimmedLine = line.trim()).startsWith("//") || !(matcher = MixinManager.MIXIN_COMMENT_PATTERN.matcher(trimmedLine)).find());
            String string = matcher.group(1);
            return string;
        }
        catch (IOException e) {
            Kubeloader.LOGGER.error("Error extracting target file from comments", (Throwable)e);
        }
        return null;
    }

    public String toString() {
        return "ModContentPack[mod=%s]".formatted(this.mod.getModId());
    }
}

