/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl.mod;

import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.ContentPack;
import com.whisent.kubeloader.definition.ContentPackProvider;
import com.whisent.kubeloader.definition.ContentPackUtils;
import com.whisent.kubeloader.impl.mod.ModContentPack;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;

public class ModContentPackProvider
implements ContentPackProvider {
    private final IModInfo mod;

    public ModContentPackProvider(IModInfo mod) {
        this.mod = mod;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    @NotNull
    public @NotNull Collection<? extends @NotNull ContentPack> providePack() {
        Path path = this.mod.getOwningFile().getFile().getFilePath();
        ContentPack got = this.scanSingle(path);
        return got == null ? List.of() : List.of(got);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ContentPack scanSingle(Path path) {
        try (JarFile file = new JarFile(path.toFile());){
            ZipEntry entry = file.getEntry("contentpacks/contentpack.json");
            if (entry == null) {
                ContentPack contentPack = null;
                return contentPack;
            }
            if (entry.isDirectory()) {
                throw new RuntimeException(String.format("%s should be a file, but got a directory", "contentpack.json"));
            }
            ModContentPack modContentPack = new ModContentPack(this.mod, ContentPackUtils.loadMetaDataOrThrow(file.getInputStream(entry)));
            return modContentPack;
        }
        catch (Exception e) {
            Kubeloader.LOGGER.error("Error when searching for ModContentPack in mod '{}'", (Object)this.mod.getModId(), (Object)e);
            return null;
        }
    }

    public String toString() {
        return "ModContentPackProvider[mod=%s]".formatted(this.mod.getModId());
    }
}

