/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl.path;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.ContentPack;
import com.whisent.kubeloader.definition.ContentPackUtils;
import com.whisent.kubeloader.definition.PackLoadingContext;
import com.whisent.kubeloader.definition.meta.PackMetaData;
import com.whisent.kubeloader.mixinjs.MixinManager;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class PathContentPack
implements ContentPack {
    private final Path base;
    private final PackMetaData metaData;
    private final Path resourcePath;
    private final Path dataPath;

    public PathContentPack(Path base) {
        this.base = base;
        this.metaData = this.loadMetaData(base);
        this.resourcePath = base.resolve("assets");
        this.dataPath = base.resolve("data");
    }

    public Path getResourcePath() {
        return this.resourcePath;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PackMetaData loadMetaData(Path base) {
        try (BufferedReader reader = Files.newBufferedReader(base.resolve("contentpack.json"));){
            DataResult result = PackMetaData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)Kubeloader.GSON.fromJson((Reader)reader, JsonObject.class)));
            if (result.result().isPresent()) {
                PackMetaData packMetaData = (PackMetaData)result.result().get();
                return packMetaData;
            }
            String errorMessage = ((DataResult.PartialResult)result.error().orElseThrow()).message();
            throw new RuntimeException("Error when parsing metadata: " + errorMessage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PackMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    @Nullable
    public ScriptPack getPack(PackLoadingContext context) {
        Path scriptPath;
        if (context.manager().scriptType.isStartup() || UtilsJS.staticServer != null) {
            MixinManager.loadMixins(this.base.resolve("mixin_scripts"), this.id() + ":");
        }
        if (!Files.isDirectory(scriptPath = this.base.resolve(context.folderName()), new LinkOption[0])) {
            return null;
        }
        ScriptPack pack = ContentPackUtils.createEmptyPack(context, this.id());
        KubeJS.loadScripts((ScriptPack)pack, (Path)scriptPath, (String)"");
        for (ScriptFileInfo fileInfo : pack.info.scripts) {
            ScriptSource.FromPath scriptSource = info -> scriptPath.resolve(info.file);
            context.loadFile(pack, fileInfo, (ScriptSource)scriptSource);
        }
        return pack;
    }

    public Set<String> getNamespaces(PackType packType) {
        Path path = this.getPathForType(packType);
        HashSet<String> namespaces = new HashSet<String>();
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> paths = Files.list(path);){
                paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).forEach(namespaces::add);
            }
            catch (IOException e) {
                Kubeloader.LOGGER.error("Failed to list namespaces in path: {}", (Object)path, (Object)e);
            }
        }
        return namespaces;
    }

    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        Path path = this.getPathForType(packType);
        Path resourcePath = path.resolve(location.m_135827_()).resolve(location.m_135815_());
        if (Files.exists(resourcePath, new LinkOption[0])) {
            return IoSupplier.m_246697_((Path)resourcePath);
        }
        return null;
    }

    private Path getPathForType(PackType packType) {
        return packType == PackType.CLIENT_RESOURCES ? this.resourcePath : this.dataPath;
    }

    public String toString() {
        return "PathContentPack[namespace='%s']".formatted(this.id());
    }
}

