/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl.path;

import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.ContentPack;
import com.whisent.kubeloader.definition.ContentPackProvider;
import com.whisent.kubeloader.impl.path.PathContentPack;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PathContentPackProvider
implements ContentPackProvider {
    private final Path base;

    public PathContentPackProvider(Path base) {
        this.base = base;
    }

    @Override
    @NotNull
    public @NotNull Collection<? extends @NotNull ContentPack> providePack() {
        try {
            return Files.list(this.base).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(PathContentPack::new).toList();
        }
        catch (IOException e) {
            Kubeloader.LOGGER.error("Error when collecting ContentPack information from path", (Throwable)e);
            return List.of();
        }
    }
}

