/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl.path;

import com.whisent.kubeloader.impl.path.PathContentPack;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.metadata.pack.PackMetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class PathContentPackResources
implements PackResources {
    private final String name;
    private final PathContentPack contentPack;
    private PackMetadataSection packMeta;

    public PathContentPackResources(String name, PathContentPack contentPack) {
        this.name = name;
        this.contentPack = contentPack;
    }

    public String m_5542_() {
        return this.name;
    }

    public String toString() {
        return "PathContentPackResources[" + this.name + "]";
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation resourceLocation) {
        return this.contentPack.getResource(packType, resourceLocation);
    }

    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        Path basePath = packType == PackType.CLIENT_RESOURCES ? this.contentPack.getResourcePath() : this.contentPack.getDataPath();
        Path namespacePath = basePath.resolve(namespace).resolve(path);
        if (Files.isDirectory(namespacePath, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(namespacePath, new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    String fileName = namespacePath.relativize((Path)file).toString().replace('\\', '/');
                    Object fullPath = path.isEmpty() ? fileName : path + "/" + fileName;
                    ResourceLocation location = ResourceLocation.m_214293_((String)namespace, (String)fullPath);
                    if (location != null) {
                        resourceOutput.accept((Object)location, (Object)IoSupplier.m_246697_((Path)file));
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Set<String> m_5698_(PackType packType) {
        return this.contentPack.getNamespaces(packType);
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metadataSectionSerializer) {
        if (metadataSectionSerializer instanceof PackMetadataSectionSerializer) {
            if (this.packMeta == null) {
                this.packMeta = this.createDefaultPackMeta();
            }
            return (T)this.packMeta;
        }
        return null;
    }

    private PackMetadataSection createDefaultPackMeta() {
        return new PackMetadataSection((Component)Component.m_237113_((String)("Content Pack: " + this.name)), 15);
    }

    public void close() {
    }
}

